/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IReplicationController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReplicationController
extends KubernetesResource
implements IReplicationController {
    private static final String REPLICATION_CONTROLLER_REPLICA_COUNT = "spec.replicas";
    private static final String REPLICATION_CONTROLLER_REPLICA_SELECTOR = "spec.selector";
    private static final String REPLICATION_CONTROLLER_CONTAINERS = "spec.template.spec.containers";
    private static final String REPLICATION_CONTROLLER_CURRENT_REPLICA_COUNT = "status.replicas";

    public ReplicationController(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public int getDesiredReplicaCount() {
        return this.asInt(REPLICATION_CONTROLLER_REPLICA_COUNT);
    }

    @Override
    public Map<String, String> getReplicaSelector() {
        return this.asMap(REPLICATION_CONTROLLER_REPLICA_SELECTOR);
    }

    @Override
    public int getCurrentReplicaCount() {
        return this.asInt(REPLICATION_CONTROLLER_CURRENT_REPLICA_COUNT);
    }

    @Override
    public Collection<String> getImages() {
        ModelNode node = this.get(REPLICATION_CONTROLLER_CONTAINERS);
        if (node.getType() != ModelType.LIST) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ModelNode entry : node.asList()) {
            list.add(entry.get("image").asString());
        }
        return list;
    }
}

