/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.ModelNodeAdapter;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.model.IServicePort;
import java.util.HashMap;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class ServicePort
extends ModelNodeAdapter
implements IServicePort {
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_PORT = "port";
    private static final String PROPERTY_PROTOCOL = "protocol";
    private static final String PROPERTY_TARGET_PORT = "targetPort";
    private static final Map<String, String[]> KEY_MAP = new HashMap<String, String[]>();

    public ServicePort(ModelNode node) {
        super(node, KEY_MAP);
    }

    public ServicePort(ModelNode node, IServicePort port) {
        this(node);
        this.setName(port.getName());
        this.setPort(port.getPort());
        this.setProtocol(port.getProtocol());
        this.setTargetPort(port.getTargetPort());
    }

    @Override
    public String getName() {
        return JBossDmrExtentions.asString(this.getNode(), KEY_MAP, PROPERTY_NAME);
    }

    @Override
    public void setName(String name) {
        JBossDmrExtentions.set(this.getNode(), KEY_MAP, PROPERTY_NAME, name);
    }

    @Override
    public int getTargetPort() {
        return JBossDmrExtentions.asInt(this.getNode(), KEY_MAP, PROPERTY_TARGET_PORT);
    }

    @Override
    public void setTargetPort(int port) {
        JBossDmrExtentions.set(this.getNode(), KEY_MAP, PROPERTY_TARGET_PORT, port);
    }

    @Override
    public void setPort(int port) {
        JBossDmrExtentions.set(this.getNode(), KEY_MAP, PROPERTY_PORT, port);
    }

    @Override
    public int getPort() {
        return JBossDmrExtentions.asInt(this.getNode(), KEY_MAP, PROPERTY_PORT);
    }

    @Override
    public String getProtocol() {
        return JBossDmrExtentions.asString(this.getNode(), KEY_MAP, PROPERTY_PROTOCOL);
    }

    @Override
    public void setProtocol(String proto) {
        JBossDmrExtentions.set(this.getNode(), KEY_MAP, PROPERTY_PROTOCOL, proto);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getPort();
        result = 31 * result + this.getTargetPort();
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServicePort other = (ServicePort)obj;
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getTargetPort() != other.getTargetPort()) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getProtocol() == null ? other.getProtocol() != null : !this.getProtocol().equals(other.getProtocol()));
    }

    public String toString() {
        return this.toJson(false);
    }

    static {
        KEY_MAP.put(PROPERTY_NAME, new String[]{PROPERTY_NAME});
        KEY_MAP.put(PROPERTY_PORT, new String[]{PROPERTY_PORT});
        KEY_MAP.put(PROPERTY_PROTOCOL, new String[]{PROPERTY_PROTOCOL});
        KEY_MAP.put(PROPERTY_TARGET_PORT, new String[]{PROPERTY_TARGET_PORT});
    }
}

