/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.deploy;

import com.openshift.internal.restclient.model.deploy.DeploymentTrigger;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.deploy.IDeploymentImageChangeTrigger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class ImageChangeTrigger
extends DeploymentTrigger
implements IDeploymentImageChangeTrigger {
    private static final String DEPLOYMENTCONFIG_TRIGGER_IMAGECHANGE_AUTO = "imageChangeParams.automatic";
    private static final String DEPLOYMENTCONFIG_TRIGGER_CONTAINERS = "imageChangeParams.containerNames";
    private static final String DEPLOYMENTCONFIG_TRIGGER_FROM = "imageChangeParams.from.name";
    private static final String DEPLOYMENTCONFIG_TRIGGER_FROM_KIND = "imageChangeParams.from.kind";

    public ImageChangeTrigger(ModelNode node, Map<String, String[]> propertyKeys) {
        super(node, propertyKeys);
    }

    @Override
    public DockerImageURI getFrom() {
        return new DockerImageURI(JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), DEPLOYMENTCONFIG_TRIGGER_FROM));
    }

    @Override
    public void setFrom(DockerImageURI fromImage) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), DEPLOYMENTCONFIG_TRIGGER_FROM_KIND, "ImageStreamTag");
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), DEPLOYMENTCONFIG_TRIGGER_FROM, fromImage.getAbsoluteUri());
    }

    @Override
    public boolean isAutomatic() {
        return JBossDmrExtentions.asBoolean(this.getNode(), this.getPropertyKeys(), DEPLOYMENTCONFIG_TRIGGER_IMAGECHANGE_AUTO);
    }

    @Override
    public void setAutomatic(boolean auto) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), DEPLOYMENTCONFIG_TRIGGER_IMAGECHANGE_AUTO, auto);
    }

    @Override
    public Collection<String> getContainerNames() {
        ArrayList<String> containers = new ArrayList<String>();
        ModelNode containerNode = JBossDmrExtentions.get(this.getNode(), this.getPropertyKeys(), DEPLOYMENTCONFIG_TRIGGER_CONTAINERS);
        if (containerNode.isDefined()) {
            for (ModelNode node : containerNode.asList()) {
                containers.add(node.asString());
            }
        }
        return containers;
    }

    @Override
    public void setContainerNames(Collection<String> names) {
        ModelNode containerNode = JBossDmrExtentions.get(this.getNode(), this.getPropertyKeys(), DEPLOYMENTCONFIG_TRIGGER_CONTAINERS);
        containerNode.clear();
        for (String name : names) {
            containerNode.add(name);
        }
    }

    @Override
    public void setContainerName(String name) {
        this.setContainerNames(Arrays.asList(name));
    }
}

