/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.model.ModelNodeBuilder;
import com.openshift.internal.restclient.model.image.ImageStreamImport;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.capability.resources.IImageStreamImportCapability;
import com.openshift.restclient.http.IHttpConstants;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.image.IImageStreamImport;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRegistryImageStreamImportCapability
implements IImageStreamImportCapability,
IHttpConstants,
ResourcePropertyKeys {
    private static final String TOKEN = "token";
    private static final String STATUS_STATUS = "status.status";
    private static final int TIMEOUT = 10000;
    private static final String ID = "id";
    private static final String PARENT = "parent";
    private static final String REALM = "realm";
    private static final Logger LOG = LoggerFactory.getLogger(IImageStreamImportCapability.class);
    private static final String DEFAULT_DOCKER_REGISTRY = "https://registry-1.docker.io/v2";
    private IResourceFactory factory;
    private IProject project;

    public DockerRegistryImageStreamImportCapability(IProject project, IResourceFactory factory) {
        this.factory = factory;
        this.project = project;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return DockerRegistryImageStreamImportCapability.class.getSimpleName();
    }

    private boolean registryExists(HttpClient client) throws Exception {
        ContentResponse response = client.newRequest(DEFAULT_DOCKER_REGISTRY).send();
        if (response == null) {
            return false;
        }
        return response.getStatus() == 401 || response.getStatus() == 200;
    }

    private String retrieveAuthToken(HttpClient client, String details) throws Exception {
        if (StringUtils.isNotBlank((String)details)) {
            Map<String, String> auth = this.parseAuthDetails(details);
            if (auth.containsKey(REALM)) {
                Request request = this.createAuthRequest(client, auth);
                ContentResponse response = request.send();
                LOG.debug("Auth response: " + response.toString());
                if (response.getStatus() == 200 && response.getHeaders().contains("Content-Type", "application/json")) {
                    ModelNode tokenNode = ModelNode.fromJSONString((String)response.getContentAsString());
                    if (tokenNode.hasDefined(TOKEN)) {
                        return tokenNode.get(TOKEN).asString();
                    }
                    LOG.debug("No auth token was found on auth response: " + tokenNode.toJSONString(false));
                } else {
                    LOG.info("Unable to retrieve authentication token as response was not OK and/or unexpected content type");
                }
            } else {
                LOG.info("Unable to retrieve authentication token - 'realm' was not found in the authenticate header: " + auth.toString());
            }
        }
        return null;
    }

    private Request createAuthRequest(HttpClient client, Map<String, String> authParams) {
        Request request = client.newRequest(StringUtils.strip((String)authParams.get(REALM), (String)"\""));
        for (Map.Entry<String, String> e : authParams.entrySet()) {
            if (REALM.equals(e.getKey())) continue;
            request.param(StringUtils.strip((String)e.getKey(), (String)"\""), StringUtils.strip((String)e.getValue(), (String)"\""));
        }
        LOG.debug("Auth request uri: " + request.getURI());
        return request;
    }

    private Map<String, String> parseAuthDetails(String auth) {
        LOG.debug("Auth details header: " + auth);
        HashMap<String, String> map = new HashMap<String, String>();
        String[] authAndValues = auth.split(" ");
        if (authAndValues.length == 2 && "Bearer".equals(authAndValues[0])) {
            String[] params;
            for (String p : params = authAndValues[1].split(",")) {
                String[] knv = p.split("=");
                if (knv.length < 2) continue;
                map.put(knv[0], knv[1]);
            }
        }
        return map;
    }

    private DockerResponse retrieveMetaData(HttpClient client, String token, DockerImageURI uri) throws Exception {
        String regUri = String.format("%s/%s/%s/manifests/%s", DEFAULT_DOCKER_REGISTRY, StringUtils.defaultIfBlank((String)uri.getUserName(), (String)"library"), uri.getName(), uri.getTag());
        Request request = client.newRequest(regUri);
        if (token != null) {
            request.header("Authorization", String.format("%s %s", "Bearer", token));
        }
        LOG.debug("retrieveMetaData uri: " + regUri);
        ContentResponse response = request.send();
        LOG.debug("retrieveMetaData response: " + response.toString());
        switch (response.getStatus()) {
            case 200: {
                return new DockerResponse("data", response.getContentAsString());
            }
            case 401: {
                return new DockerResponse("auth", response.getHeaders().get(HttpHeader.WWW_AUTHENTICATE));
            }
        }
        LOG.info("Unable to retrieve docker meta data: " + response.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImageStreamImport importImageMetadata(DockerImageURI uri) {
        HttpClient client = null;
        try {
            SslContextFactory sslFactory = new SslContextFactory(true);
            client = new HttpClient(sslFactory);
            client.setConnectTimeout(10000L);
            client.start();
            if (this.registryExists(client)) {
                String token = null;
                DockerResponse response = this.retrieveMetaData(client, token, uri);
                if ("auth".equals(response.getResponseType())) {
                    LOG.debug("Unauthorized.  Trying to retrieve token...");
                    token = this.retrieveAuthToken(client, response.getData());
                    response = this.retrieveMetaData(client, token, uri);
                }
                if ("data".equals(response.getResponseType())) {
                    String meta = response.getData();
                    LOG.debug("Raw Docker image metadata: " + meta);
                    IImageStreamImport iImageStreamImport = this.buildResponse(meta, uri);
                    return iImageStreamImport;
                }
                LOG.info("Unable to retrieve image metadata from docker registry");
                IImageStreamImport iImageStreamImport = this.buildErrorResponse(uri);
                return iImageStreamImport;
            }
        }
        catch (Exception e) {
            LOG.error("Exception while trying to retrieve image metadata from docker", (Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    client.stop();
                }
            }
            catch (Exception e) {
                LOG.warn("Exception while trying to stop http client", (Throwable)e);
            }
        }
        return this.buildErrorResponse(uri);
    }

    private IImageStreamImport buildErrorResponse(DockerImageURI uri) {
        ModelNodeBuilder builder = new ModelNodeBuilder().set(STATUS_STATUS, "Failure").set("status.message", String.format("you may not have access to the Docker image \"%s\"", uri.getUriWithoutHost())).set("status.reason", "Unauthorized").set("status.code", 401);
        return this.buildImageStreamImport(uri, builder.build());
    }

    private IImageStreamImport buildResponse(String meta, DockerImageURI uri) {
        ModelNode raw = ModelNode.fromJSONString((String)meta);
        ModelNode last = this.findNewestHistoryEntry(raw);
        ModelNode containerConfig = last.remove("container_config");
        last.get("ContainerConfig").set(containerConfig);
        ModelNodeBuilder builder = new ModelNodeBuilder().set(STATUS_STATUS, "Success").set("tag", uri.getTag()).set("image.metadata.name", uri.getName()).set("image.dockerImageReference", uri.getUriUserNameAndName()).set("image.dockerImageMetadata", last);
        return this.buildImageStreamImport(uri, builder.build());
    }

    private ImageStreamImport buildImageStreamImport(DockerImageURI uri, ModelNode node) {
        ImageStreamImport isImport = (ImageStreamImport)this.factory.stub("ImageStreamImport", uri.getName(), this.project.getName());
        ModelNode root = isImport.getNode();
        ModelNode images = JBossDmrExtentions.get(root, null, "status.images");
        images.add(node);
        return isImport;
    }

    private ModelNode findNewestHistoryEntry(ModelNode root) {
        ModelNode history = root.get("history");
        List entries = history.asList().stream().map(n -> ModelNode.fromJSONString((String)n.get("v1Compatibility").asString())).collect(Collectors.toList());
        entries.sort(new Comparator<ModelNode>(){

            @Override
            public int compare(ModelNode one, ModelNode two) {
                String parent2;
                String parent1 = one.has(DockerRegistryImageStreamImportCapability.PARENT) ? one.get(DockerRegistryImageStreamImportCapability.PARENT).asString() : null;
                String string = parent2 = two.has(DockerRegistryImageStreamImportCapability.PARENT) ? one.get(DockerRegistryImageStreamImportCapability.PARENT).asString() : null;
                if (parent1 == null && parent2 != null) {
                    return -1;
                }
                if (parent1 != null && parent2 == null) {
                    return 1;
                }
                if (parent1 == null && parent2 == null) {
                    return 0;
                }
                String id1 = one.get(DockerRegistryImageStreamImportCapability.ID).asString();
                String id2 = two.get(DockerRegistryImageStreamImportCapability.ID).asString();
                if (parent2.equals(id1)) {
                    return -1;
                }
                if (parent1.equals(id2)) {
                    return 1;
                }
                return 0;
            }
        });
        ModelNode last = (ModelNode)entries.get(0);
        LOG.debug("newest history: " + last.toJSONString(false));
        return last;
    }

    private static class DockerResponse {
        public static final String DATA = "data";
        public static final String AUTH = "auth";
        String responseType;
        String data;

        DockerResponse(String responseType, String data) {
            this.responseType = responseType;
            this.data = data;
        }

        public Object getResponseType() {
            return this.responseType;
        }

        public String getData() {
            return this.data;
        }
    }
}

