/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.build;

import com.openshift.restclient.model.build.IWebhookTrigger;
import org.apache.commons.lang.StringUtils;

public class WebhookTrigger
implements IWebhookTrigger {
    private String type;
    private String secret;
    private String baseURL;

    public WebhookTrigger(String triggerType, String secret, String baseURL) {
        this.type = triggerType;
        this.secret = secret;
        this.baseURL = baseURL;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public String getWebhookURL() {
        if (StringUtils.isBlank((String)this.baseURL)) {
            return "";
        }
        return String.format("%s/webhooks/%s/%s", this.baseURL, this.secret, this.type.toLowerCase());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.secret == null ? 0 : this.secret.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebhookTrigger other = (WebhookTrigger)obj;
        if (this.secret == null ? other.secret != null : !this.secret.equals(other.secret)) {
            return false;
        }
        return this.type == other.type;
    }
}

