/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class Project
extends KubernetesResource
implements IProject {
    private static final String ANNOTATION_DISPLAY_NAME = "openshift.io/display-name";
    private static final String ANNOTATION_DESCRIPTION = "openshift.io/description";

    public Project(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
        CapabilityInitializer.initializeCapabilities(this.getModifiableCapabilities(), this, this.getClient());
    }

    @Override
    public IProject getProject() {
        return this;
    }

    @Override
    public String getNamespaceName() {
        if (StringUtils.isEmpty((String)super.getNamespaceName())) {
            return this.getName();
        }
        return super.getNamespaceName();
    }

    @Override
    public String getDisplayName() {
        return this.getAnnotation(ANNOTATION_DISPLAY_NAME);
    }

    @Override
    public void setDisplayName(String name) {
        this.setAnnotation(ANNOTATION_DISPLAY_NAME, name);
    }

    @Override
    public String getDescription() {
        return this.getAnnotation(ANNOTATION_DESCRIPTION);
    }

    @Override
    public void setDescription(String value) {
        this.setAnnotation(ANNOTATION_DESCRIPTION, value);
    }

    @Override
    public <T extends IResource> List<T> getResources(String kind) {
        if (this.getClient() == null) {
            return new ArrayList();
        }
        return this.getClient().list(kind, this.getName());
    }
}

