/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.model.ReplicationController;
import com.openshift.internal.restclient.model.deploy.ConfigChangeTrigger;
import com.openshift.internal.restclient.model.deploy.DeploymentTrigger;
import com.openshift.internal.restclient.model.deploy.ImageChangeTrigger;
import com.openshift.restclient.IClient;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.deploy.IDeploymentTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentConfig
extends ReplicationController
implements IDeploymentConfig {
    public static final String DEPLOYMENTCONFIG_CONTAINERS = "spec.template.spec.containers";
    private static final String DEPLOYMENTCONFIG_TRIGGERS = "spec.triggers";
    private static final String DEPLOYMENTCONFIG_STRATEGY = "spec.strategy.type";
    private static final String DEPLOYMENTCONFIG_LATEST_VERSION = "status.latestVersion";
    private static final String DEPLOYMENTCONFIG_CAUSES = "status.details.causes";
    private static final String TYPE = "type";
    private static final String IMAGE_CHANGE = "ImageChange";
    private static final String IMAGE_TRIGGER = "imageTrigger";
    private static final String FROM = "from";
    private static final String NAME = "name";
    private static final String IMAGE_CHANGE_PARAMS = "imageChangeParams";
    private static final String LAST_TRIGGER_IMAGE = "lastTriggeredImage";
    private static final String IMAGE_TRIGGER_FROM_NAME = "imageTrigger.from.name";
    private static final String IMAGE_CHANGE_PARAMS_FROM_NAME = "imageChangeParams.from.name";
    private static final String IMAGE_CHANGE_PARAMS_LAST_TRIGGER_IMAGE = "imageChangeParams.lastTriggeredImage";
    private final Map<String, String[]> propertyKeys;

    public DeploymentConfig(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
        this.propertyKeys = propertyKeys;
        CapabilityInitializer.initializeCapabilities(this.getModifiableCapabilities(), this, this.getClient());
    }

    @Override
    public Collection<String> getTriggerTypes() {
        ArrayList<String> types = new ArrayList<String>();
        ModelNode triggers = this.get(DEPLOYMENTCONFIG_TRIGGERS);
        for (ModelNode node : triggers.asList()) {
            types.add(this.asString(node, TYPE));
        }
        return types;
    }

    @Override
    public Collection<IDeploymentTrigger> getTriggers() {
        ArrayList<IDeploymentTrigger> triggers = new ArrayList<IDeploymentTrigger>();
        ModelNode list = this.get(DEPLOYMENTCONFIG_TRIGGERS);
        for (ModelNode node : list.asList()) {
            String type;
            switch (type = this.asString(node, TYPE)) {
                case "ConfigChange": {
                    triggers.add(new ConfigChangeTrigger(node, this.propertyKeys));
                    break;
                }
                case "ImageChange": {
                    triggers.add(new ImageChangeTrigger(node, this.propertyKeys));
                }
            }
        }
        return triggers;
    }

    public List<String> getImageNames() {
        ArrayList<String> names = new ArrayList<String>();
        List containers = this.get(DEPLOYMENTCONFIG_CONTAINERS).asList();
        for (ModelNode container : containers) {
            names.add(container.get("image").asString());
        }
        return names;
    }

    @Override
    public int getLatestVersionNumber() {
        return this.asInt(DEPLOYMENTCONFIG_LATEST_VERSION);
    }

    @Override
    public void setLatestVersionNumber(int newVersionNumber) {
        this.set(DEPLOYMENTCONFIG_LATEST_VERSION, newVersionNumber);
    }

    @Override
    public IDeploymentTrigger addTrigger(String type) {
        ModelNode triggers = this.get(DEPLOYMENTCONFIG_TRIGGERS);
        ModelNode triggerNode = triggers.add();
        triggerNode.get(TYPE).set(type);
        switch (type) {
            case "ImageChange": {
                return new ImageChangeTrigger(triggerNode, this.propertyKeys);
            }
        }
        return new DeploymentTrigger(triggerNode, this.propertyKeys);
    }

    @Override
    public String getDeploymentStrategyType() {
        return this.asString(DEPLOYMENTCONFIG_STRATEGY);
    }

    @Override
    public boolean haveTriggersFired() {
        ModelNode causes = this.get(DEPLOYMENTCONFIG_CAUSES);
        if (causes.getType() == ModelType.UNDEFINED || causes.getType() != ModelType.LIST) {
            return false;
        }
        return !causes.asList().isEmpty();
    }

    @Override
    public boolean didImageTrigger(String imageNameTag) {
        if (!this.haveTriggersFired() || imageNameTag == null) {
            return false;
        }
        ModelNode causes = this.get(DEPLOYMENTCONFIG_CAUSES);
        if (causes.getType() == ModelType.UNDEFINED || causes.getType() != ModelType.LIST) {
            return false;
        }
        for (ModelNode cause : causes.asList()) {
            String triggerName;
            DockerImageURI uri;
            String type = this.asString(cause, TYPE);
            if (!type.equalsIgnoreCase(IMAGE_CHANGE) || !imageNameTag.equals((uri = new DockerImageURI(triggerName = this.asString(cause, IMAGE_TRIGGER_FROM_NAME))).getNameAndTag())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getImageHexIDForImageNameAndTag(String imageNameTag) {
        ModelNode triggers = this.get(DEPLOYMENTCONFIG_TRIGGERS);
        if (triggers.getType() == ModelType.UNDEFINED || triggers.getType() != ModelType.LIST || imageNameTag == null) {
            return null;
        }
        for (ModelNode trigger : triggers.asList()) {
            if (!this.asString(trigger, TYPE).equalsIgnoreCase(IMAGE_CHANGE)) continue;
            String nameTag = null;
            nameTag = this.asString(trigger, IMAGE_CHANGE_PARAMS_FROM_NAME);
            if (!imageNameTag.equals(nameTag)) continue;
            return this.asString(trigger, IMAGE_CHANGE_PARAMS_LAST_TRIGGER_IMAGE);
        }
        return null;
    }

    @Override
    public String getImageNameAndTagForTriggeredDeployment() {
        ModelNode causes = this.get(DEPLOYMENTCONFIG_CAUSES);
        if (causes.getType() == ModelType.UNDEFINED || causes.getType() != ModelType.LIST) {
            return null;
        }
        for (ModelNode cause : causes.asList()) {
            String type = this.asString(cause, TYPE);
            if (!type.equalsIgnoreCase(IMAGE_CHANGE)) continue;
            String imageTag = this.asString(cause, IMAGE_TRIGGER_FROM_NAME);
            DockerImageURI uri = new DockerImageURI(imageTag);
            return uri.getNameAndTag();
        }
        return null;
    }
}

