/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.flows;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.types.FlowDetail;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncFlowsClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawFlowsClient rawClient;

  public AsyncFlowsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawFlowsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawFlowsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * List all flows in the organization.
   */
  public CompletableFuture<List<FlowDetail>> list() {
    return this.rawClient.list().thenApply(response -> response.body());
  }

  /**
   * List all flows in the organization.
   */
  public CompletableFuture<List<FlowDetail>> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).thenApply(response -> response.body());
  }
}
