/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.folders;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.assets.folders.requests.DeleteFolderRequest;
import com.rulebricks.resources.assets.folders.requests.UpsertFolderRequest;
import com.rulebricks.types.Folder;
import java.util.List;

public class FoldersClient {
  protected final ClientOptions clientOptions;

  private final RawFoldersClient rawClient;

  public FoldersClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawFoldersClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawFoldersClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieve all rule folders for the authenticated user.
   */
  public List<Folder> list() {
    return this.rawClient.list().body();
  }

  /**
   * Retrieve all rule folders for the authenticated user.
   */
  public List<Folder> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).body();
  }

  /**
   * Create a new rule folder or update an existing one for the authenticated user.
   */
  public Folder upsert(UpsertFolderRequest request) {
    return this.rawClient.upsert(request).body();
  }

  /**
   * Create a new rule folder or update an existing one for the authenticated user.
   */
  public Folder upsert(UpsertFolderRequest request, RequestOptions requestOptions) {
    return this.rawClient.upsert(request, requestOptions).body();
  }

  /**
   * Delete a specific rule folder for the authenticated user. This does not delete the rules within the folder.
   */
  public Folder delete(DeleteFolderRequest request) {
    return this.rawClient.delete(request).body();
  }

  /**
   * Delete a specific rule folder for the authenticated user. This does not delete the rules within the folder.
   */
  public Folder delete(DeleteFolderRequest request, RequestOptions requestOptions) {
    return this.rawClient.delete(request, requestOptions).body();
  }
}
