/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.rules;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.assets.rules.requests.DeleteRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ImportRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ListRulesRequest;
import com.rulebricks.resources.assets.rules.requests.PullRulesRequest;
import com.rulebricks.types.RuleDetail;
import com.rulebricks.types.SuccessMessage;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;

public class RulesClient {
  protected final ClientOptions clientOptions;

  private final RawRulesClient rawClient;

  public RulesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawRulesClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawRulesClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Delete a specific rule by its ID.
   */
  public SuccessMessage delete(DeleteRuleRequest request) {
    return this.rawClient.delete(request).body();
  }

  /**
   * Delete a specific rule by its ID.
   */
  public SuccessMessage delete(DeleteRuleRequest request, RequestOptions requestOptions) {
    return this.rawClient.delete(request, requestOptions).body();
  }

  /**
   * Export a specific rule by its ID.
   */
  public Map<String, Object> pull(PullRulesRequest request) {
    return this.rawClient.pull(request).body();
  }

  /**
   * Export a specific rule by its ID.
   */
  public Map<String, Object> pull(PullRulesRequest request, RequestOptions requestOptions) {
    return this.rawClient.pull(request, requestOptions).body();
  }

  /**
   * Import a rule into the user's account.
   */
  public Map<String, Object> push(ImportRuleRequest request) {
    return this.rawClient.push(request).body();
  }

  /**
   * Import a rule into the user's account.
   */
  public Map<String, Object> push(ImportRuleRequest request, RequestOptions requestOptions) {
    return this.rawClient.push(request, requestOptions).body();
  }

  /**
   * List all rules in the organization. Optionally filter by folder name or ID.
   */
  public List<RuleDetail> list() {
    return this.rawClient.list().body();
  }

  /**
   * List all rules in the organization. Optionally filter by folder name or ID.
   */
  public List<RuleDetail> list(ListRulesRequest request) {
    return this.rawClient.list(request).body();
  }

  /**
   * List all rules in the organization. Optionally filter by folder name or ID.
   */
  public List<RuleDetail> list(ListRulesRequest request, RequestOptions requestOptions) {
    return this.rawClient.list(request, requestOptions).body();
  }
}
