/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.tests.rules;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.errors.NotFoundError;
import com.rulebricks.resources.tests.rules.requests.CreateRulesRequest;
import com.rulebricks.resources.tests.rules.requests.DeleteRulesRequest;
import com.rulebricks.resources.tests.rules.requests.ListRulesRequest;
import com.rulebricks.types.Test;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawRulesClient {
  protected final ClientOptions clientOptions;

  public AsyncRawRulesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieves a list of tests associated with the rule identified by the slug.
   */
  public CompletableFuture<RulebricksApiHttpResponse<List<Test>>> list(String slug) {
    return list(slug,ListRulesRequest.builder().build());
  }

  /**
   * Retrieves a list of tests associated with the rule identified by the slug.
   */
  public CompletableFuture<RulebricksApiHttpResponse<List<Test>>> list(String slug,
      ListRulesRequest request) {
    return list(slug,request,null);
  }

  /**
   * Retrieves a list of tests associated with the rule identified by the slug.
   */
  public CompletableFuture<RulebricksApiHttpResponse<List<Test>>> list(String slug,
      ListRulesRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/rules")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .build();
    Request.Builder _requestBuilder = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Accept", "application/json");
    Request okhttpRequest = _requestBuilder.build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<List<Test>>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<List<Test>>() {}), response));
            return;
          }
          try {
            switch (response.code()) {
              case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Adds a new test to the test suite of a rule identified by the slug.
   */
  public CompletableFuture<RulebricksApiHttpResponse<Test>> create(String slug,
      CreateRulesRequest request) {
    return create(slug,request,null);
  }

  /**
   * Adds a new test to the test suite of a rule identified by the slug.
   */
  public CompletableFuture<RulebricksApiHttpResponse<Test>> create(String slug,
      CreateRulesRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/rules")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
    }
    catch(JsonProcessingException e) {
      throw new RulebricksApiException("Failed to serialize request", e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("POST", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<Test>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Test.class), response));
            return;
          }
          try {
            switch (response.code()) {
              case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Deletes a test from the test suite of a rule identified by the slug.
   */
  public CompletableFuture<RulebricksApiHttpResponse<Test>> delete(String slug, String testId) {
    return delete(slug,testId,DeleteRulesRequest.builder().build());
  }

  /**
   * Deletes a test from the test suite of a rule identified by the slug.
   */
  public CompletableFuture<RulebricksApiHttpResponse<Test>> delete(String slug, String testId,
      DeleteRulesRequest request) {
    return delete(slug,testId,request,null);
  }

  /**
   * Deletes a test from the test suite of a rule identified by the slug.
   */
  public CompletableFuture<RulebricksApiHttpResponse<Test>> delete(String slug, String testId,
      DeleteRulesRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/rules")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .addPathSegment(testId)
      .build();
    Request.Builder _requestBuilder = new Request.Builder()
      .url(httpUrl)
      .method("DELETE", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Accept", "application/json");
    Request okhttpRequest = _requestBuilder.build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<Test>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Test.class), response));
            return;
          }
          try {
            switch (response.code()) {
              case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }
}
