/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.users.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateUserRequest.Builder.class
)
public final class CreateUserRequest {
  private final String email;

  private final String password;

  private final Optional<String> name;

  private final Optional<String> role;

  private final Optional<List<String>> accessGroups;

  private final Map<String, Object> additionalProperties;

  private CreateUserRequest(String email, String password, Optional<String> name,
      Optional<String> role, Optional<List<String>> accessGroups,
      Map<String, Object> additionalProperties) {
    this.email = email;
    this.password = password;
    this.name = name;
    this.role = role;
    this.accessGroups = accessGroups;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Email address for the new user.
   */
  @JsonProperty("email")
  public String getEmail() {
    return email;
  }

  /**
   * @return Password for the new user (minimum 8 characters). The user can log in immediately with this password.
   */
  @JsonProperty("password")
  public String getPassword() {
    return password;
  }

  /**
   * @return Display name for the user.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Role to assign to the user. Defaults to 'developer' if not specified.
   */
  @JsonProperty("role")
  public Optional<String> getRole() {
    return role;
  }

  /**
   * @return List of access group names or IDs to assign to the user.
   */
  @JsonProperty("accessGroups")
  public Optional<List<String>> getAccessGroups() {
    return accessGroups;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateUserRequest && equalTo((CreateUserRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateUserRequest other) {
    return email.equals(other.email) && password.equals(other.password) && name.equals(other.name) && role.equals(other.role) && accessGroups.equals(other.accessGroups);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.email, this.password, this.name, this.role, this.accessGroups);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static EmailStage builder() {
    return new Builder();
  }

  public interface EmailStage {
    /**
     * <p>Email address for the new user.</p>
     */
    PasswordStage email(@NotNull String email);

    Builder from(CreateUserRequest other);
  }

  public interface PasswordStage {
    /**
     * <p>Password for the new user (minimum 8 characters). The user can log in immediately with this password.</p>
     */
    _FinalStage password(@NotNull String password);
  }

  public interface _FinalStage {
    CreateUserRequest build();

    /**
     * <p>Display name for the user.</p>
     */
    _FinalStage name(Optional<String> name);

    _FinalStage name(String name);

    /**
     * <p>Role to assign to the user. Defaults to 'developer' if not specified.</p>
     */
    _FinalStage role(Optional<String> role);

    _FinalStage role(String role);

    /**
     * <p>List of access group names or IDs to assign to the user.</p>
     */
    _FinalStage accessGroups(Optional<List<String>> accessGroups);

    _FinalStage accessGroups(List<String> accessGroups);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements EmailStage, PasswordStage, _FinalStage {
    private String email;

    private String password;

    private Optional<List<String>> accessGroups = Optional.empty();

    private Optional<String> role = Optional.empty();

    private Optional<String> name = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateUserRequest other) {
      email(other.getEmail());
      password(other.getPassword());
      name(other.getName());
      role(other.getRole());
      accessGroups(other.getAccessGroups());
      return this;
    }

    /**
     * <p>Email address for the new user.</p>
     * <p>Email address for the new user.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("email")
    public PasswordStage email(@NotNull String email) {
      this.email = Objects.requireNonNull(email, "email must not be null");
      return this;
    }

    /**
     * <p>Password for the new user (minimum 8 characters). The user can log in immediately with this password.</p>
     * <p>Password for the new user (minimum 8 characters). The user can log in immediately with this password.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("password")
    public _FinalStage password(@NotNull String password) {
      this.password = Objects.requireNonNull(password, "password must not be null");
      return this;
    }

    /**
     * <p>List of access group names or IDs to assign to the user.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage accessGroups(List<String> accessGroups) {
      this.accessGroups = Optional.ofNullable(accessGroups);
      return this;
    }

    /**
     * <p>List of access group names or IDs to assign to the user.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "accessGroups",
        nulls = Nulls.SKIP
    )
    public _FinalStage accessGroups(Optional<List<String>> accessGroups) {
      this.accessGroups = accessGroups;
      return this;
    }

    /**
     * <p>Role to assign to the user. Defaults to 'developer' if not specified.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage role(String role) {
      this.role = Optional.ofNullable(role);
      return this;
    }

    /**
     * <p>Role to assign to the user. Defaults to 'developer' if not specified.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "role",
        nulls = Nulls.SKIP
    )
    public _FinalStage role(Optional<String> role) {
      this.role = role;
      return this;
    }

    /**
     * <p>Display name for the user.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>Display name for the user.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public _FinalStage name(Optional<String> name) {
      this.name = name;
      return this;
    }

    @java.lang.Override
    public CreateUserRequest build() {
      return new CreateUserRequest(email, password, name, role, accessGroups, additionalProperties);
    }
  }
}
