/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.values;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.QueryStringMapper;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.ForbiddenError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.errors.NotFoundError;
import com.rulebricks.resources.values.requests.DeleteValuesRequest;
import com.rulebricks.resources.values.requests.ListValuesRequest;
import com.rulebricks.resources.values.requests.UpdateValuesRequest;
import com.rulebricks.types.DynamicValue;
import com.rulebricks.types.SuccessMessage;
import java.io.IOException;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawValuesClient {
  protected final ClientOptions clientOptions;

  public RawValuesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieve all dynamic values for the authenticated user. Use the 'include' parameter to control whether usage information is returned.
   */
  public RulebricksApiHttpResponse<List<DynamicValue>> list() {
    return list(ListValuesRequest.builder().build());
  }

  /**
   * Retrieve all dynamic values for the authenticated user. Use the 'include' parameter to control whether usage information is returned.
   */
  public RulebricksApiHttpResponse<List<DynamicValue>> list(ListValuesRequest request) {
    return list(request,null);
  }

  /**
   * Retrieve all dynamic values for the authenticated user. Use the 'include' parameter to control whether usage information is returned.
   */
  public RulebricksApiHttpResponse<List<DynamicValue>> list(ListValuesRequest request,
      RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("values");if (request.getName().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "name", request.getName().get(), false);
      }
      if (request.getInclude().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "include", request.getInclude().get(), false);
      }
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Accept", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      try (Response response = client.newCall(okhttpRequest).execute()) {
        ResponseBody responseBody = response.body();
        String responseBodyString = responseBody != null ? responseBody.string() : "{}";
        if (response.isSuccessful()) {
          return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<List<DynamicValue>>() {}), response);
        }
        try {
          switch (response.code()) {
            case 404:throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          }
        }
        catch (JsonProcessingException ignored) {
          // unable to map error response, throwing generic error
        }
        Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
        throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
      }
      catch (IOException e) {
        throw new RulebricksApiException("Network error executing HTTP request", e);
      }
    }

    /**
     * Update existing dynamic values or add new ones for the authenticated user. Supports both flat and nested object structures. Nested objects are automatically flattened using dot notation and keys are converted to readable format (e.g., 'user_name' becomes 'User Name', nested 'user.contact_info.email' becomes 'User.Contact Info.Email').
     */
    public RulebricksApiHttpResponse<List<DynamicValue>> update(UpdateValuesRequest request) {
      return update(request,null);
    }

    /**
     * Update existing dynamic values or add new ones for the authenticated user. Supports both flat and nested object structures. Nested objects are automatically flattened using dot notation and keys are converted to readable format (e.g., 'user_name' becomes 'User Name', nested 'user.contact_info.email' becomes 'User.Contact Info.Email').
     */
    public RulebricksApiHttpResponse<List<DynamicValue>> update(UpdateValuesRequest request,
        RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("values")
        .build();
      RequestBody body;
      try {
        body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
      }
      catch(JsonProcessingException e) {
        throw new RulebricksApiException("Failed to serialize request", e);
      }
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("POST", body)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .addHeader("Accept", "application/json")
        .build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      try (Response response = client.newCall(okhttpRequest).execute()) {
        ResponseBody responseBody = response.body();
        String responseBodyString = responseBody != null ? responseBody.string() : "{}";
        if (response.isSuccessful()) {
          return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<List<DynamicValue>>() {}), response);
        }
        try {
          switch (response.code()) {
            case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            case 403:throw new ForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          }
        }
        catch (JsonProcessingException ignored) {
          // unable to map error response, throwing generic error
        }
        Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
        throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
      }
      catch (IOException e) {
        throw new RulebricksApiException("Network error executing HTTP request", e);
      }
    }

    /**
     * Delete a specific dynamic value for the authenticated user by its ID.
     */
    public RulebricksApiHttpResponse<SuccessMessage> delete(DeleteValuesRequest request) {
      return delete(request,null);
    }

    /**
     * Delete a specific dynamic value for the authenticated user by its ID.
     */
    public RulebricksApiHttpResponse<SuccessMessage> delete(DeleteValuesRequest request,
        RequestOptions requestOptions) {
      HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("values");QueryStringMapper.addQueryParameter(httpUrl, "id", request.getId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
          .url(httpUrl.build())
          .method("DELETE", null)
          .headers(Headers.of(clientOptions.headers(requestOptions)))
          .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
          client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
          ResponseBody responseBody = response.body();
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SuccessMessage.class), response);
          }
          try {
            switch (response.code()) {
              case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
              case 404:throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
              case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
          throw new RulebricksApiException("Network error executing HTTP request", e);
        }
      }
    }
