/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = DecisionLogResponse.Builder.class
)
public final class DecisionLogResponse {
  private final Optional<List<DecisionLog>> data;

  private final Optional<String> cursor;

  private final Optional<Integer> count;

  private final Map<String, Object> additionalProperties;

  private DecisionLogResponse(Optional<List<DecisionLog>> data, Optional<String> cursor,
      Optional<Integer> count, Map<String, Object> additionalProperties) {
    this.data = data;
    this.cursor = cursor;
    this.count = count;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Array of decision log entries (omitted when count=true).
   */
  @JsonProperty("data")
  public Optional<List<DecisionLog>> getData() {
    return data;
  }

  /**
   * @return Pagination cursor for fetching the next page. Null if no more results.
   */
  @JsonIgnore
  public Optional<String> getCursor() {
    if (cursor == null) {
      return Optional.empty();
    }
    return cursor;
  }

  /**
   * @return Total count of matching logs (only present when count=true parameter is used).
   */
  @JsonProperty("count")
  public Optional<Integer> getCount() {
    return count;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("cursor")
  private Optional<String> _getCursor() {
    return cursor;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DecisionLogResponse && equalTo((DecisionLogResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(DecisionLogResponse other) {
    return data.equals(other.data) && cursor.equals(other.cursor) && count.equals(other.count);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.data, this.cursor, this.count);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<List<DecisionLog>> data = Optional.empty();

    private Optional<String> cursor = Optional.empty();

    private Optional<Integer> count = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(DecisionLogResponse other) {
      data(other.getData());
      cursor(other.getCursor());
      count(other.getCount());
      return this;
    }

    /**
     * <p>Array of decision log entries (omitted when count=true).</p>
     */
    @JsonSetter(
        value = "data",
        nulls = Nulls.SKIP
    )
    public Builder data(Optional<List<DecisionLog>> data) {
      this.data = data;
      return this;
    }

    public Builder data(List<DecisionLog> data) {
      this.data = Optional.ofNullable(data);
      return this;
    }

    /**
     * <p>Pagination cursor for fetching the next page. Null if no more results.</p>
     */
    @JsonSetter(
        value = "cursor",
        nulls = Nulls.SKIP
    )
    public Builder cursor(Optional<String> cursor) {
      this.cursor = cursor;
      return this;
    }

    public Builder cursor(String cursor) {
      this.cursor = Optional.ofNullable(cursor);
      return this;
    }

    public Builder cursor(Nullable<String> cursor) {
      if (cursor.isNull()) {
        this.cursor = null;
      }
      else if (cursor.isEmpty()) {
        this.cursor = Optional.empty();
      }
      else {
        this.cursor = Optional.of(cursor.get());
      }
      return this;
    }

    /**
     * <p>Total count of matching logs (only present when count=true parameter is used).</p>
     */
    @JsonSetter(
        value = "count",
        nulls = Nulls.SKIP
    )
    public Builder count(Optional<Integer> count) {
      this.count = count;
      return this;
    }

    public Builder count(Integer count) {
      this.count = Optional.ofNullable(count);
      return this;
    }

    public DecisionLogResponse build() {
      return new DecisionLogResponse(data, cursor, count, additionalProperties);
    }
  }
}
