/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks;

import com.rulebricks.AsyncRulebricksApiClient;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.Environment;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.OkHttpClient;

public class AsyncRulebricksApiClientBuilder {
    private Optional<Integer> timeout = Optional.empty();
    private Optional<Integer> maxRetries = Optional.empty();
    private final Map<String, String> customHeaders = new HashMap<String, String>();
    private String apiKey = null;
    private Environment environment = Environment.DEFAULT;
    private OkHttpClient httpClient;

    public AsyncRulebricksApiClientBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public AsyncRulebricksApiClientBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public AsyncRulebricksApiClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public AsyncRulebricksApiClientBuilder timeout(int timeout) {
        this.timeout = Optional.of(timeout);
        return this;
    }

    public AsyncRulebricksApiClientBuilder maxRetries(int maxRetries) {
        this.maxRetries = Optional.of(maxRetries);
        return this;
    }

    public AsyncRulebricksApiClientBuilder httpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public AsyncRulebricksApiClientBuilder addHeader(String name, String value) {
        this.customHeaders.put(name, value);
        return this;
    }

    protected ClientOptions buildClientOptions() {
        ClientOptions.Builder builder = ClientOptions.builder();
        this.setEnvironment(builder);
        this.setAuthentication(builder);
        this.setHttpClient(builder);
        this.setTimeouts(builder);
        this.setRetries(builder);
        for (Map.Entry<String, String> header : this.customHeaders.entrySet()) {
            builder.addHeader(header.getKey(), header.getValue());
        }
        this.setAdditional(builder);
        return builder.build();
    }

    protected void setEnvironment(ClientOptions.Builder builder) {
        builder.environment(this.environment);
    }

    protected void setAuthentication(ClientOptions.Builder builder) {
        builder.addHeader("x-api-key", this.apiKey);
    }

    protected void setTimeouts(ClientOptions.Builder builder) {
        if (this.timeout.isPresent()) {
            builder.timeout(this.timeout.get());
        }
    }

    protected void setRetries(ClientOptions.Builder builder) {
        if (this.maxRetries.isPresent()) {
            builder.maxRetries(this.maxRetries.get());
        }
    }

    protected void setHttpClient(ClientOptions.Builder builder) {
        if (this.httpClient != null) {
            builder.httpClient(this.httpClient);
        }
    }

    protected void setAdditional(ClientOptions.Builder builder) {
    }

    protected void validateConfiguration() {
    }

    public AsyncRulebricksApiClient build() {
        if (this.apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.validateConfiguration();
        return new AsyncRulebricksApiClient(this.buildClientOptions());
    }
}

