/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets.folders;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.assets.folders.AsyncRawFoldersClient;
import com.rulebricks.resources.assets.folders.requests.DeleteFolderRequest;
import com.rulebricks.resources.assets.folders.requests.UpsertFolderRequest;
import com.rulebricks.types.Folder;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncFoldersClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawFoldersClient rawClient;

    public AsyncFoldersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawFoldersClient(clientOptions);
    }

    public AsyncRawFoldersClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<Folder>> list() {
        return this.rawClient.list().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Folder>> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<Folder> upsert(UpsertFolderRequest request) {
        return this.rawClient.upsert(request).thenApply(response -> (Folder)response.body());
    }

    public CompletableFuture<Folder> upsert(UpsertFolderRequest request, RequestOptions requestOptions) {
        return this.rawClient.upsert(request, requestOptions).thenApply(response -> (Folder)response.body());
    }

    public CompletableFuture<Folder> delete(DeleteFolderRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (Folder)response.body());
    }

    public CompletableFuture<Folder> delete(DeleteFolderRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (Folder)response.body());
    }
}

