/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.decisions;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.decisions.AsyncRawDecisionsClient;
import com.rulebricks.resources.decisions.requests.QueryDecisionsRequest;
import com.rulebricks.types.DecisionLogResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncDecisionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDecisionsClient rawClient;

    public AsyncDecisionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDecisionsClient(clientOptions);
    }

    public AsyncRawDecisionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<DecisionLogResponse> query() {
        return this.rawClient.query().thenApply(response -> (DecisionLogResponse)response.body());
    }

    public CompletableFuture<DecisionLogResponse> query(QueryDecisionsRequest request) {
        return this.rawClient.query(request).thenApply(response -> (DecisionLogResponse)response.body());
    }

    public CompletableFuture<DecisionLogResponse> query(QueryDecisionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.query(request, requestOptions).thenApply(response -> (DecisionLogResponse)response.body());
    }
}

