/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.users.groups;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.users.groups.AsyncRawGroupsClient;
import com.rulebricks.resources.users.groups.requests.CreateUserGroupRequest;
import com.rulebricks.types.UserGroup;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncGroupsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawGroupsClient rawClient;

    public AsyncGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawGroupsClient(clientOptions);
    }

    public AsyncRawGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<UserGroup>> list() {
        return this.rawClient.list().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<UserGroup>> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<UserGroup> create(CreateUserGroupRequest request) {
        return this.rawClient.create(request).thenApply(response -> (UserGroup)response.body());
    }

    public CompletableFuture<UserGroup> create(CreateUserGroupRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (UserGroup)response.body());
    }
}

