/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks;

import com.rulebricks.RulebricksApiClientBuilder;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.assets.AssetsClient;
import com.rulebricks.resources.contexts.ContextsClient;
import com.rulebricks.resources.decisions.DecisionsClient;
import com.rulebricks.resources.flows.FlowsClient;
import com.rulebricks.resources.rules.RulesClient;
import com.rulebricks.resources.tests.TestsClient;
import com.rulebricks.resources.users.UsersClient;
import com.rulebricks.resources.values.ValuesClient;
import java.util.function.Supplier;

public class RulebricksApiClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<RulesClient> rulesClient;
    protected final Supplier<FlowsClient> flowsClient;
    protected final Supplier<DecisionsClient> decisionsClient;
    protected final Supplier<UsersClient> usersClient;
    protected final Supplier<AssetsClient> assetsClient;
    protected final Supplier<ValuesClient> valuesClient;
    protected final Supplier<ContextsClient> contextsClient;
    protected final Supplier<TestsClient> testsClient;

    public RulebricksApiClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rulesClient = Suppliers.memoize(() -> new RulesClient(clientOptions));
        this.flowsClient = Suppliers.memoize(() -> new FlowsClient(clientOptions));
        this.decisionsClient = Suppliers.memoize(() -> new DecisionsClient(clientOptions));
        this.usersClient = Suppliers.memoize(() -> new UsersClient(clientOptions));
        this.assetsClient = Suppliers.memoize(() -> new AssetsClient(clientOptions));
        this.valuesClient = Suppliers.memoize(() -> new ValuesClient(clientOptions));
        this.contextsClient = Suppliers.memoize(() -> new ContextsClient(clientOptions));
        this.testsClient = Suppliers.memoize(() -> new TestsClient(clientOptions));
    }

    public RulesClient rules() {
        return this.rulesClient.get();
    }

    public FlowsClient flows() {
        return this.flowsClient.get();
    }

    public DecisionsClient decisions() {
        return this.decisionsClient.get();
    }

    public UsersClient users() {
        return this.usersClient.get();
    }

    public AssetsClient assets() {
        return this.assetsClient.get();
    }

    public ValuesClient values() {
        return this.valuesClient.get();
    }

    public ContextsClient contexts() {
        return this.contextsClient.get();
    }

    public TestsClient tests() {
        return this.testsClient.get();
    }

    public static RulebricksApiClientBuilder builder() {
        return new RulebricksApiClientBuilder();
    }
}

