/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.assets.AsyncRawAssetsClient;
import com.rulebricks.resources.assets.flows.AsyncFlowsClient;
import com.rulebricks.resources.assets.folders.AsyncFoldersClient;
import com.rulebricks.resources.assets.requests.ExportManifestRequest;
import com.rulebricks.resources.assets.requests.ImportManifestRequest;
import com.rulebricks.resources.assets.rules.AsyncRulesClient;
import com.rulebricks.resources.assets.types.ExportAssetsResponse;
import com.rulebricks.types.ImportManifestResponse;
import com.rulebricks.types.UsageStatistics;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncAssetsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawAssetsClient rawClient;
    protected final Supplier<AsyncRulesClient> rulesClient;
    protected final Supplier<AsyncFlowsClient> flowsClient;
    protected final Supplier<AsyncFoldersClient> foldersClient;

    public AsyncAssetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAssetsClient(clientOptions);
        this.rulesClient = Suppliers.memoize(() -> new AsyncRulesClient(clientOptions));
        this.flowsClient = Suppliers.memoize(() -> new AsyncFlowsClient(clientOptions));
        this.foldersClient = Suppliers.memoize(() -> new AsyncFoldersClient(clientOptions));
    }

    public AsyncRawAssetsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<UsageStatistics> getUsage() {
        return this.rawClient.getUsage().thenApply(response -> (UsageStatistics)response.body());
    }

    public CompletableFuture<UsageStatistics> getUsage(RequestOptions requestOptions) {
        return this.rawClient.getUsage(requestOptions).thenApply(response -> (UsageStatistics)response.body());
    }

    public CompletableFuture<ImportManifestResponse> import_(ImportManifestRequest request) {
        return this.rawClient.import_(request).thenApply(response -> (ImportManifestResponse)response.body());
    }

    public CompletableFuture<ImportManifestResponse> import_(ImportManifestRequest request, RequestOptions requestOptions) {
        return this.rawClient.import_(request, requestOptions).thenApply(response -> (ImportManifestResponse)response.body());
    }

    public CompletableFuture<ExportAssetsResponse> export() {
        return this.rawClient.export().thenApply(response -> (ExportAssetsResponse)response.body());
    }

    public CompletableFuture<ExportAssetsResponse> export(ExportManifestRequest request) {
        return this.rawClient.export(request).thenApply(response -> (ExportAssetsResponse)response.body());
    }

    public CompletableFuture<ExportAssetsResponse> export(ExportManifestRequest request, RequestOptions requestOptions) {
        return this.rawClient.export(request, requestOptions).thenApply(response -> (ExportAssetsResponse)response.body());
    }

    public AsyncRulesClient rules() {
        return this.rulesClient.get();
    }

    public AsyncFlowsClient flows() {
        return this.flowsClient.get();
    }

    public AsyncFoldersClient folders() {
        return this.foldersClient.get();
    }
}

