/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.resources.assets.requests.ExportManifestRequest;
import com.rulebricks.resources.assets.requests.ImportManifestRequest;
import com.rulebricks.resources.assets.types.ExportAssetsResponse;
import com.rulebricks.types.ImportManifestResponse;
import com.rulebricks.types.UsageStatistics;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawAssetsClient {
    protected final ClientOptions clientOptions;

    public RawAssetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public RulebricksApiHttpResponse<UsageStatistics> getUsage() {
        return this.getUsage(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<UsageStatistics> getUsage(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/usage").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<UsageStatistics> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<UsageStatistics>((UsageStatistics)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UsageStatistics.class), response);
                return rulebricksApiHttpResponse;
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<ImportManifestResponse> import_(ImportManifestRequest request) {
        return this.import_(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<ImportManifestResponse> import_(ImportManifestRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/import").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<ImportManifestResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<ImportManifestResponse>((ImportManifestResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ImportManifestResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<ExportAssetsResponse> export() {
        return this.export(ExportManifestRequest.builder().build());
    }

    public RulebricksApiHttpResponse<ExportAssetsResponse> export(ExportManifestRequest request) {
        return this.export(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<ExportAssetsResponse> export(ExportManifestRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/export").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<ExportAssetsResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<ExportAssetsResponse>((ExportAssetsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ExportAssetsResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }
}

