/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ExportManifestRequest {
    private final Optional<List<String>> rules;
    private final Optional<List<String>> flows;
    private final Optional<List<String>> contexts;
    private final Optional<List<String>> values;
    private final Optional<Boolean> includeAll;
    private final Optional<Boolean> preview;
    private final Map<String, Object> additionalProperties;

    private ExportManifestRequest(Optional<List<String>> rules, Optional<List<String>> flows, Optional<List<String>> contexts, Optional<List<String>> values, Optional<Boolean> includeAll, Optional<Boolean> preview, Map<String, Object> additionalProperties) {
        this.rules = rules;
        this.flows = flows;
        this.contexts = contexts;
        this.values = values;
        this.includeAll = includeAll;
        this.preview = preview;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="rules")
    public Optional<List<String>> getRules() {
        return this.rules;
    }

    @JsonProperty(value="flows")
    public Optional<List<String>> getFlows() {
        return this.flows;
    }

    @JsonProperty(value="contexts")
    public Optional<List<String>> getContexts() {
        return this.contexts;
    }

    @JsonProperty(value="values")
    public Optional<List<String>> getValues() {
        return this.values;
    }

    @JsonProperty(value="includeAll")
    public Optional<Boolean> getIncludeAll() {
        return this.includeAll;
    }

    @JsonProperty(value="preview")
    public Optional<Boolean> getPreview() {
        return this.preview;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExportManifestRequest && this.equalTo((ExportManifestRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExportManifestRequest other) {
        return this.rules.equals(other.rules) && this.flows.equals(other.flows) && this.contexts.equals(other.contexts) && this.values.equals(other.values) && this.includeAll.equals(other.includeAll) && this.preview.equals(other.preview);
    }

    public int hashCode() {
        return Objects.hash(this.rules, this.flows, this.contexts, this.values, this.includeAll, this.preview);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> rules = Optional.empty();
        private Optional<List<String>> flows = Optional.empty();
        private Optional<List<String>> contexts = Optional.empty();
        private Optional<List<String>> values = Optional.empty();
        private Optional<Boolean> includeAll = Optional.empty();
        private Optional<Boolean> preview = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ExportManifestRequest other) {
            this.rules(other.getRules());
            this.flows(other.getFlows());
            this.contexts(other.getContexts());
            this.values(other.getValues());
            this.includeAll(other.getIncludeAll());
            this.preview(other.getPreview());
            return this;
        }

        @JsonSetter(value="rules", nulls=Nulls.SKIP)
        public Builder rules(Optional<List<String>> rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(List<String> rules) {
            this.rules = Optional.ofNullable(rules);
            return this;
        }

        @JsonSetter(value="flows", nulls=Nulls.SKIP)
        public Builder flows(Optional<List<String>> flows) {
            this.flows = flows;
            return this;
        }

        public Builder flows(List<String> flows) {
            this.flows = Optional.ofNullable(flows);
            return this;
        }

        @JsonSetter(value="contexts", nulls=Nulls.SKIP)
        public Builder contexts(Optional<List<String>> contexts) {
            this.contexts = contexts;
            return this;
        }

        public Builder contexts(List<String> contexts) {
            this.contexts = Optional.ofNullable(contexts);
            return this;
        }

        @JsonSetter(value="values", nulls=Nulls.SKIP)
        public Builder values(Optional<List<String>> values) {
            this.values = values;
            return this;
        }

        public Builder values(List<String> values) {
            this.values = Optional.ofNullable(values);
            return this;
        }

        @JsonSetter(value="includeAll", nulls=Nulls.SKIP)
        public Builder includeAll(Optional<Boolean> includeAll) {
            this.includeAll = includeAll;
            return this;
        }

        public Builder includeAll(Boolean includeAll) {
            this.includeAll = Optional.ofNullable(includeAll);
            return this;
        }

        @JsonSetter(value="preview", nulls=Nulls.SKIP)
        public Builder preview(Optional<Boolean> preview) {
            this.preview = preview;
            return this;
        }

        public Builder preview(Boolean preview) {
            this.preview = Optional.ofNullable(preview);
            return this;
        }

        public ExportManifestRequest build() {
            return new ExportManifestRequest(this.rules, this.flows, this.contexts, this.values, this.includeAll, this.preview, this.additionalProperties);
        }
    }
}

