/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.assets.types.ImportManifestRequestManifest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ImportManifestRequest {
    private final ImportManifestRequestManifest manifest;
    private final Optional<Boolean> overwrite;
    private final Map<String, Object> additionalProperties;

    private ImportManifestRequest(ImportManifestRequestManifest manifest, Optional<Boolean> overwrite, Map<String, Object> additionalProperties) {
        this.manifest = manifest;
        this.overwrite = overwrite;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="manifest")
    public ImportManifestRequestManifest getManifest() {
        return this.manifest;
    }

    @JsonProperty(value="overwrite")
    public Optional<Boolean> getOverwrite() {
        return this.overwrite;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImportManifestRequest && this.equalTo((ImportManifestRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ImportManifestRequest other) {
        return this.manifest.equals(other.manifest) && this.overwrite.equals(other.overwrite);
    }

    public int hashCode() {
        return Objects.hash(this.manifest, this.overwrite);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ManifestStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ManifestStage,
    _FinalStage {
        private ImportManifestRequestManifest manifest;
        private Optional<Boolean> overwrite = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ImportManifestRequest other) {
            this.manifest(other.getManifest());
            this.overwrite(other.getOverwrite());
            return this;
        }

        @Override
        @JsonSetter(value="manifest")
        public _FinalStage manifest(@NotNull ImportManifestRequestManifest manifest) {
            this.manifest = Objects.requireNonNull(manifest, "manifest must not be null");
            return this;
        }

        @Override
        public _FinalStage overwrite(Boolean overwrite) {
            this.overwrite = Optional.ofNullable(overwrite);
            return this;
        }

        @Override
        @JsonSetter(value="overwrite", nulls=Nulls.SKIP)
        public _FinalStage overwrite(Optional<Boolean> overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        @Override
        public ImportManifestRequest build() {
            return new ImportManifestRequest(this.manifest, this.overwrite, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ImportManifestRequest build();

        public _FinalStage overwrite(Optional<Boolean> var1);

        public _FinalStage overwrite(Boolean var1);
    }

    public static interface ManifestStage {
        public _FinalStage manifest(@NotNull ImportManifestRequestManifest var1);

        public Builder from(ImportManifestRequest var1);
    }
}

