/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.contexts.AsyncRawContextsClient;
import com.rulebricks.resources.contexts.admin.AsyncAdminClient;
import com.rulebricks.resources.contexts.relationships.AsyncRelationshipsClient;
import com.rulebricks.resources.contexts.requests.CascadeContextRequest;
import com.rulebricks.resources.contexts.requests.DeleteInstanceContextsRequest;
import com.rulebricks.resources.contexts.requests.GetHistoryContextsRequest;
import com.rulebricks.resources.contexts.requests.GetInstanceContextsRequest;
import com.rulebricks.resources.contexts.requests.GetPendingContextsRequest;
import com.rulebricks.resources.contexts.requests.SolveContextFlowRequest;
import com.rulebricks.resources.contexts.requests.SolveContextRuleRequest;
import com.rulebricks.resources.contexts.requests.SubmitContextsRequest;
import com.rulebricks.types.CascadeContextResponse;
import com.rulebricks.types.ContextInstanceHistory;
import com.rulebricks.types.ContextInstancePendingResponse;
import com.rulebricks.types.ContextInstanceState;
import com.rulebricks.types.DeleteContextInstanceResponse;
import com.rulebricks.types.SolveContextFlowResponse;
import com.rulebricks.types.SolveContextRuleResponse;
import com.rulebricks.types.SubmitContextDataResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncContextsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawContextsClient rawClient;
    protected final Supplier<AsyncAdminClient> adminClient;
    protected final Supplier<AsyncRelationshipsClient> relationshipsClient;

    public AsyncContextsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawContextsClient(clientOptions);
        this.adminClient = Suppliers.memoize(() -> new AsyncAdminClient(clientOptions));
        this.relationshipsClient = Suppliers.memoize(() -> new AsyncRelationshipsClient(clientOptions));
    }

    public AsyncRawContextsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ContextInstanceState> getInstance(String slug, String instance) {
        return this.rawClient.getInstance(slug, instance).thenApply(response -> (ContextInstanceState)response.body());
    }

    public CompletableFuture<ContextInstanceState> getInstance(String slug, String instance, GetInstanceContextsRequest request) {
        return this.rawClient.getInstance(slug, instance, request).thenApply(response -> (ContextInstanceState)response.body());
    }

    public CompletableFuture<ContextInstanceState> getInstance(String slug, String instance, GetInstanceContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.getInstance(slug, instance, request, requestOptions).thenApply(response -> (ContextInstanceState)response.body());
    }

    public CompletableFuture<SubmitContextDataResponse> submit(String slug, String instance, SubmitContextsRequest request) {
        return this.rawClient.submit(slug, instance, request).thenApply(response -> (SubmitContextDataResponse)response.body());
    }

    public CompletableFuture<SubmitContextDataResponse> submit(String slug, String instance, SubmitContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.submit(slug, instance, request, requestOptions).thenApply(response -> (SubmitContextDataResponse)response.body());
    }

    public CompletableFuture<DeleteContextInstanceResponse> deleteInstance(String slug, String instance) {
        return this.rawClient.deleteInstance(slug, instance).thenApply(response -> (DeleteContextInstanceResponse)response.body());
    }

    public CompletableFuture<DeleteContextInstanceResponse> deleteInstance(String slug, String instance, DeleteInstanceContextsRequest request) {
        return this.rawClient.deleteInstance(slug, instance, request).thenApply(response -> (DeleteContextInstanceResponse)response.body());
    }

    public CompletableFuture<DeleteContextInstanceResponse> deleteInstance(String slug, String instance, DeleteInstanceContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteInstance(slug, instance, request, requestOptions).thenApply(response -> (DeleteContextInstanceResponse)response.body());
    }

    public CompletableFuture<ContextInstanceHistory> getHistory(String slug, String instance) {
        return this.rawClient.getHistory(slug, instance).thenApply(response -> (ContextInstanceHistory)response.body());
    }

    public CompletableFuture<ContextInstanceHistory> getHistory(String slug, String instance, GetHistoryContextsRequest request) {
        return this.rawClient.getHistory(slug, instance, request).thenApply(response -> (ContextInstanceHistory)response.body());
    }

    public CompletableFuture<ContextInstanceHistory> getHistory(String slug, String instance, GetHistoryContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.getHistory(slug, instance, request, requestOptions).thenApply(response -> (ContextInstanceHistory)response.body());
    }

    public CompletableFuture<ContextInstancePendingResponse> getPending(String slug, String instance) {
        return this.rawClient.getPending(slug, instance).thenApply(response -> (ContextInstancePendingResponse)response.body());
    }

    public CompletableFuture<ContextInstancePendingResponse> getPending(String slug, String instance, GetPendingContextsRequest request) {
        return this.rawClient.getPending(slug, instance, request).thenApply(response -> (ContextInstancePendingResponse)response.body());
    }

    public CompletableFuture<ContextInstancePendingResponse> getPending(String slug, String instance, GetPendingContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.getPending(slug, instance, request, requestOptions).thenApply(response -> (ContextInstancePendingResponse)response.body());
    }

    public CompletableFuture<SolveContextRuleResponse> solve(String slug, String instance, String ruleSlug) {
        return this.rawClient.solve(slug, instance, ruleSlug).thenApply(response -> (SolveContextRuleResponse)response.body());
    }

    public CompletableFuture<SolveContextRuleResponse> solve(String slug, String instance, String ruleSlug, SolveContextRuleRequest request) {
        return this.rawClient.solve(slug, instance, ruleSlug, request).thenApply(response -> (SolveContextRuleResponse)response.body());
    }

    public CompletableFuture<SolveContextRuleResponse> solve(String slug, String instance, String ruleSlug, SolveContextRuleRequest request, RequestOptions requestOptions) {
        return this.rawClient.solve(slug, instance, ruleSlug, request, requestOptions).thenApply(response -> (SolveContextRuleResponse)response.body());
    }

    public CompletableFuture<CascadeContextResponse> cascade(String slug, String instance) {
        return this.rawClient.cascade(slug, instance).thenApply(response -> (CascadeContextResponse)response.body());
    }

    public CompletableFuture<CascadeContextResponse> cascade(String slug, String instance, CascadeContextRequest request) {
        return this.rawClient.cascade(slug, instance, request).thenApply(response -> (CascadeContextResponse)response.body());
    }

    public CompletableFuture<CascadeContextResponse> cascade(String slug, String instance, CascadeContextRequest request, RequestOptions requestOptions) {
        return this.rawClient.cascade(slug, instance, request, requestOptions).thenApply(response -> (CascadeContextResponse)response.body());
    }

    public CompletableFuture<SolveContextFlowResponse> execute(String slug, String instance, String flowSlug) {
        return this.rawClient.execute(slug, instance, flowSlug).thenApply(response -> (SolveContextFlowResponse)response.body());
    }

    public CompletableFuture<SolveContextFlowResponse> execute(String slug, String instance, String flowSlug, SolveContextFlowRequest request) {
        return this.rawClient.execute(slug, instance, flowSlug, request).thenApply(response -> (SolveContextFlowResponse)response.body());
    }

    public CompletableFuture<SolveContextFlowResponse> execute(String slug, String instance, String flowSlug, SolveContextFlowRequest request, RequestOptions requestOptions) {
        return this.rawClient.execute(slug, instance, flowSlug, request, requestOptions).thenApply(response -> (SolveContextFlowResponse)response.body());
    }

    public AsyncAdminClient admin() {
        return this.adminClient.get();
    }

    public AsyncRelationshipsClient relationships() {
        return this.relationshipsClient.get();
    }
}

