/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts.admin;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.admin.AsyncRawAdminClient;
import com.rulebricks.resources.contexts.admin.requests.CreateContextRequest;
import com.rulebricks.resources.contexts.admin.requests.DeleteAdminRequest;
import com.rulebricks.resources.contexts.admin.requests.GetAdminRequest;
import com.rulebricks.resources.contexts.admin.requests.UpdateContextRequest;
import com.rulebricks.types.ContextDetail;
import com.rulebricks.types.DeleteContextResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncAdminClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawAdminClient rawClient;

    public AsyncAdminClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAdminClient(clientOptions);
    }

    public AsyncRawAdminClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<ContextDetail>> list() {
        return this.rawClient.list().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ContextDetail>> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<ContextDetail> create(CreateContextRequest request) {
        return this.rawClient.create(request).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> create(CreateContextRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> get(String id) {
        return this.rawClient.get(id).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> get(String id, GetAdminRequest request) {
        return this.rawClient.get(id, request).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> get(String id, GetAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(id, request, requestOptions).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> update(String id) {
        return this.rawClient.update(id).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> update(String id, UpdateContextRequest request) {
        return this.rawClient.update(id, request).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> update(String id, UpdateContextRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(id, request, requestOptions).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<DeleteContextResponse> delete(String id) {
        return this.rawClient.delete(id).thenApply(response -> (DeleteContextResponse)response.body());
    }

    public CompletableFuture<DeleteContextResponse> delete(String id, DeleteAdminRequest request) {
        return this.rawClient.delete(id, request).thenApply(response -> (DeleteContextResponse)response.body());
    }

    public CompletableFuture<DeleteContextResponse> delete(String id, DeleteAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(id, request, requestOptions).thenApply(response -> (DeleteContextResponse)response.body());
    }
}

