/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts.admin.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.contexts.admin.types.CreateContextRequestOnSchemaMismatch;
import com.rulebricks.resources.contexts.admin.types.CreateContextRequestSchemaItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateContextRequest {
    private final String name;
    private final Optional<String> slug;
    private final Optional<String> description;
    private final Optional<List<CreateContextRequestSchemaItem>> schema;
    private final Optional<Boolean> autoExecuteDecisions;
    private final Optional<Integer> ttlSeconds;
    private final Optional<Integer> historyLimit;
    private final Optional<CreateContextRequestOnSchemaMismatch> onSchemaMismatch;
    private final Optional<String> webhookOnSolve;
    private final Optional<String> webhookOnExpire;
    private final Map<String, Object> additionalProperties;

    private CreateContextRequest(String name, Optional<String> slug, Optional<String> description, Optional<List<CreateContextRequestSchemaItem>> schema, Optional<Boolean> autoExecuteDecisions, Optional<Integer> ttlSeconds, Optional<Integer> historyLimit, Optional<CreateContextRequestOnSchemaMismatch> onSchemaMismatch, Optional<String> webhookOnSolve, Optional<String> webhookOnExpire, Map<String, Object> additionalProperties) {
        this.name = name;
        this.slug = slug;
        this.description = description;
        this.schema = schema;
        this.autoExecuteDecisions = autoExecuteDecisions;
        this.ttlSeconds = ttlSeconds;
        this.historyLimit = historyLimit;
        this.onSchemaMismatch = onSchemaMismatch;
        this.webhookOnSolve = webhookOnSolve;
        this.webhookOnExpire = webhookOnExpire;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="slug")
    public Optional<String> getSlug() {
        return this.slug;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="schema")
    public Optional<List<CreateContextRequestSchemaItem>> getSchema() {
        return this.schema;
    }

    @JsonProperty(value="auto_execute_decisions")
    public Optional<Boolean> getAutoExecuteDecisions() {
        return this.autoExecuteDecisions;
    }

    @JsonIgnore
    public Optional<Integer> getTtlSeconds() {
        if (this.ttlSeconds == null) {
            return Optional.empty();
        }
        return this.ttlSeconds;
    }

    @JsonProperty(value="history_limit")
    public Optional<Integer> getHistoryLimit() {
        return this.historyLimit;
    }

    @JsonProperty(value="on_schema_mismatch")
    public Optional<CreateContextRequestOnSchemaMismatch> getOnSchemaMismatch() {
        return this.onSchemaMismatch;
    }

    @JsonProperty(value="webhook_on_solve")
    public Optional<String> getWebhookOnSolve() {
        return this.webhookOnSolve;
    }

    @JsonProperty(value="webhook_on_expire")
    public Optional<String> getWebhookOnExpire() {
        return this.webhookOnExpire;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ttl_seconds")
    private Optional<Integer> _getTtlSeconds() {
        return this.ttlSeconds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateContextRequest && this.equalTo((CreateContextRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateContextRequest other) {
        return this.name.equals(other.name) && this.slug.equals(other.slug) && this.description.equals(other.description) && this.schema.equals(other.schema) && this.autoExecuteDecisions.equals(other.autoExecuteDecisions) && this.ttlSeconds.equals(other.ttlSeconds) && this.historyLimit.equals(other.historyLimit) && this.onSchemaMismatch.equals(other.onSchemaMismatch) && this.webhookOnSolve.equals(other.webhookOnSolve) && this.webhookOnExpire.equals(other.webhookOnExpire);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.slug, this.description, this.schema, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private Optional<String> webhookOnExpire = Optional.empty();
        private Optional<String> webhookOnSolve = Optional.empty();
        private Optional<CreateContextRequestOnSchemaMismatch> onSchemaMismatch = Optional.empty();
        private Optional<Integer> historyLimit = Optional.empty();
        private Optional<Integer> ttlSeconds = Optional.empty();
        private Optional<Boolean> autoExecuteDecisions = Optional.empty();
        private Optional<List<CreateContextRequestSchemaItem>> schema = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> slug = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateContextRequest other) {
            this.name(other.getName());
            this.slug(other.getSlug());
            this.description(other.getDescription());
            this.schema(other.getSchema());
            this.autoExecuteDecisions(other.getAutoExecuteDecisions());
            this.ttlSeconds(other.getTtlSeconds());
            this.historyLimit(other.getHistoryLimit());
            this.onSchemaMismatch(other.getOnSchemaMismatch());
            this.webhookOnSolve(other.getWebhookOnSolve());
            this.webhookOnExpire(other.getWebhookOnExpire());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage webhookOnExpire(String webhookOnExpire) {
            this.webhookOnExpire = Optional.ofNullable(webhookOnExpire);
            return this;
        }

        @Override
        @JsonSetter(value="webhook_on_expire", nulls=Nulls.SKIP)
        public _FinalStage webhookOnExpire(Optional<String> webhookOnExpire) {
            this.webhookOnExpire = webhookOnExpire;
            return this;
        }

        @Override
        public _FinalStage webhookOnSolve(String webhookOnSolve) {
            this.webhookOnSolve = Optional.ofNullable(webhookOnSolve);
            return this;
        }

        @Override
        @JsonSetter(value="webhook_on_solve", nulls=Nulls.SKIP)
        public _FinalStage webhookOnSolve(Optional<String> webhookOnSolve) {
            this.webhookOnSolve = webhookOnSolve;
            return this;
        }

        @Override
        public _FinalStage onSchemaMismatch(CreateContextRequestOnSchemaMismatch onSchemaMismatch) {
            this.onSchemaMismatch = Optional.ofNullable(onSchemaMismatch);
            return this;
        }

        @Override
        @JsonSetter(value="on_schema_mismatch", nulls=Nulls.SKIP)
        public _FinalStage onSchemaMismatch(Optional<CreateContextRequestOnSchemaMismatch> onSchemaMismatch) {
            this.onSchemaMismatch = onSchemaMismatch;
            return this;
        }

        @Override
        public _FinalStage historyLimit(Integer historyLimit) {
            this.historyLimit = Optional.ofNullable(historyLimit);
            return this;
        }

        @Override
        @JsonSetter(value="history_limit", nulls=Nulls.SKIP)
        public _FinalStage historyLimit(Optional<Integer> historyLimit) {
            this.historyLimit = historyLimit;
            return this;
        }

        @Override
        public _FinalStage ttlSeconds(Nullable<Integer> ttlSeconds) {
            this.ttlSeconds = ttlSeconds.isNull() ? null : (ttlSeconds.isEmpty() ? Optional.empty() : Optional.of(ttlSeconds.get()));
            return this;
        }

        @Override
        public _FinalStage ttlSeconds(Integer ttlSeconds) {
            this.ttlSeconds = Optional.ofNullable(ttlSeconds);
            return this;
        }

        @Override
        @JsonSetter(value="ttl_seconds", nulls=Nulls.SKIP)
        public _FinalStage ttlSeconds(Optional<Integer> ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        @Override
        public _FinalStage autoExecuteDecisions(Boolean autoExecuteDecisions) {
            this.autoExecuteDecisions = Optional.ofNullable(autoExecuteDecisions);
            return this;
        }

        @Override
        @JsonSetter(value="auto_execute_decisions", nulls=Nulls.SKIP)
        public _FinalStage autoExecuteDecisions(Optional<Boolean> autoExecuteDecisions) {
            this.autoExecuteDecisions = autoExecuteDecisions;
            return this;
        }

        @Override
        public _FinalStage schema(List<CreateContextRequestSchemaItem> schema) {
            this.schema = Optional.ofNullable(schema);
            return this;
        }

        @Override
        @JsonSetter(value="schema", nulls=Nulls.SKIP)
        public _FinalStage schema(Optional<List<CreateContextRequestSchemaItem>> schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage slug(String slug) {
            this.slug = Optional.ofNullable(slug);
            return this;
        }

        @Override
        @JsonSetter(value="slug", nulls=Nulls.SKIP)
        public _FinalStage slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        @Override
        public CreateContextRequest build() {
            return new CreateContextRequest(this.name, this.slug, this.description, this.schema, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateContextRequest build();

        public _FinalStage slug(Optional<String> var1);

        public _FinalStage slug(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage schema(Optional<List<CreateContextRequestSchemaItem>> var1);

        public _FinalStage schema(List<CreateContextRequestSchemaItem> var1);

        public _FinalStage autoExecuteDecisions(Optional<Boolean> var1);

        public _FinalStage autoExecuteDecisions(Boolean var1);

        public _FinalStage ttlSeconds(Optional<Integer> var1);

        public _FinalStage ttlSeconds(Integer var1);

        public _FinalStage ttlSeconds(Nullable<Integer> var1);

        public _FinalStage historyLimit(Optional<Integer> var1);

        public _FinalStage historyLimit(Integer var1);

        public _FinalStage onSchemaMismatch(Optional<CreateContextRequestOnSchemaMismatch> var1);

        public _FinalStage onSchemaMismatch(CreateContextRequestOnSchemaMismatch var1);

        public _FinalStage webhookOnSolve(Optional<String> var1);

        public _FinalStage webhookOnSolve(String var1);

        public _FinalStage webhookOnExpire(Optional<String> var1);

        public _FinalStage webhookOnExpire(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);

        public Builder from(CreateContextRequest var1);
    }
}

