/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts.relationships;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.errors.NotFoundError;
import com.rulebricks.resources.contexts.relationships.requests.CreateRelationshipRequest;
import com.rulebricks.resources.contexts.relationships.requests.DeleteRelationshipsRequest;
import com.rulebricks.resources.contexts.relationships.requests.ListRelationshipsRequest;
import com.rulebricks.types.ContextRelationshipOutgoing;
import com.rulebricks.types.ContextRelationshipsResponse;
import com.rulebricks.types.DeleteRelationshipResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawRelationshipsClient {
    protected final ClientOptions clientOptions;

    public RawRelationshipsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public RulebricksApiHttpResponse<ContextRelationshipsResponse> list(String id) {
        return this.list(id, ListRelationshipsRequest.builder().build());
    }

    public RulebricksApiHttpResponse<ContextRelationshipsResponse> list(String id, ListRelationshipsRequest request) {
        return this.list(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<ContextRelationshipsResponse> list(String id, ListRelationshipsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/contexts").addPathSegment(id).addPathSegments("relationships").build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<ContextRelationshipsResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<ContextRelationshipsResponse>((ContextRelationshipsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContextRelationshipsResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<ContextRelationshipOutgoing> create(String id, CreateRelationshipRequest request) {
        return this.create(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<ContextRelationshipOutgoing> create(String id, CreateRelationshipRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/contexts").addPathSegment(id).addPathSegments("relationships").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<ContextRelationshipOutgoing> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<ContextRelationshipOutgoing>((ContextRelationshipOutgoing)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContextRelationshipOutgoing.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<DeleteRelationshipResponse> delete(String id, String relationship) {
        return this.delete(id, relationship, DeleteRelationshipsRequest.builder().build());
    }

    public RulebricksApiHttpResponse<DeleteRelationshipResponse> delete(String id, String relationship, DeleteRelationshipsRequest request) {
        return this.delete(id, relationship, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<DeleteRelationshipResponse> delete(String id, String relationship, DeleteRelationshipsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/contexts").addPathSegment(id).addPathSegments("relationships").addPathSegment(relationship).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<DeleteRelationshipResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<DeleteRelationshipResponse>((DeleteRelationshipResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DeleteRelationshipResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }
}

