/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts.relationships;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.relationships.RawRelationshipsClient;
import com.rulebricks.resources.contexts.relationships.requests.CreateRelationshipRequest;
import com.rulebricks.resources.contexts.relationships.requests.DeleteRelationshipsRequest;
import com.rulebricks.resources.contexts.relationships.requests.ListRelationshipsRequest;
import com.rulebricks.types.ContextRelationshipOutgoing;
import com.rulebricks.types.ContextRelationshipsResponse;
import com.rulebricks.types.DeleteRelationshipResponse;

public class RelationshipsClient {
    protected final ClientOptions clientOptions;
    private final RawRelationshipsClient rawClient;

    public RelationshipsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawRelationshipsClient(clientOptions);
    }

    public RawRelationshipsClient withRawResponse() {
        return this.rawClient;
    }

    public ContextRelationshipsResponse list(String id) {
        return this.rawClient.list(id).body();
    }

    public ContextRelationshipsResponse list(String id, ListRelationshipsRequest request) {
        return this.rawClient.list(id, request).body();
    }

    public ContextRelationshipsResponse list(String id, ListRelationshipsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(id, request, requestOptions).body();
    }

    public ContextRelationshipOutgoing create(String id, CreateRelationshipRequest request) {
        return this.rawClient.create(id, request).body();
    }

    public ContextRelationshipOutgoing create(String id, CreateRelationshipRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(id, request, requestOptions).body();
    }

    public DeleteRelationshipResponse delete(String id, String relationship) {
        return this.rawClient.delete(id, relationship).body();
    }

    public DeleteRelationshipResponse delete(String id, String relationship, DeleteRelationshipsRequest request) {
        return this.rawClient.delete(id, relationship, request).body();
    }

    public DeleteRelationshipResponse delete(String id, String relationship, DeleteRelationshipsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(id, relationship, request, requestOptions).body();
    }
}

