/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts.relationships.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.contexts.relationships.types.CreateRelationshipRequestType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateRelationshipRequest {
    private final String targetContextId;
    private final CreateRelationshipRequestType type;
    private final String foreignKey;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private CreateRelationshipRequest(String targetContextId, CreateRelationshipRequestType type, String foreignKey, Optional<String> name, Optional<String> description, Map<String, Object> additionalProperties) {
        this.targetContextId = targetContextId;
        this.type = type;
        this.foreignKey = foreignKey;
        this.name = name;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="targetContextId")
    public String getTargetContextId() {
        return this.targetContextId;
    }

    @JsonProperty(value="type")
    public CreateRelationshipRequestType getType() {
        return this.type;
    }

    @JsonProperty(value="foreignKey")
    public String getForeignKey() {
        return this.foreignKey;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateRelationshipRequest && this.equalTo((CreateRelationshipRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateRelationshipRequest other) {
        return this.targetContextId.equals(other.targetContextId) && this.type.equals(other.type) && this.foreignKey.equals(other.foreignKey) && this.name.equals(other.name) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.targetContextId, this.type, this.foreignKey, this.name, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TargetContextIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TargetContextIdStage,
    TypeStage,
    ForeignKeyStage,
    _FinalStage {
        private String targetContextId;
        private CreateRelationshipRequestType type;
        private String foreignKey;
        private Optional<String> description = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateRelationshipRequest other) {
            this.targetContextId(other.getTargetContextId());
            this.type(other.getType());
            this.foreignKey(other.getForeignKey());
            this.name(other.getName());
            this.description(other.getDescription());
            return this;
        }

        @Override
        @JsonSetter(value="targetContextId")
        public TypeStage targetContextId(@NotNull String targetContextId) {
            this.targetContextId = Objects.requireNonNull(targetContextId, "targetContextId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public ForeignKeyStage type(@NotNull CreateRelationshipRequestType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="foreignKey")
        public _FinalStage foreignKey(@NotNull String foreignKey) {
            this.foreignKey = Objects.requireNonNull(foreignKey, "foreignKey must not be null");
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public CreateRelationshipRequest build() {
            return new CreateRelationshipRequest(this.targetContextId, this.type, this.foreignKey, this.name, this.description, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateRelationshipRequest build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);
    }

    public static interface ForeignKeyStage {
        public _FinalStage foreignKey(@NotNull String var1);
    }

    public static interface TypeStage {
        public ForeignKeyStage type(@NotNull CreateRelationshipRequestType var1);
    }

    public static interface TargetContextIdStage {
        public TypeStage targetContextId(@NotNull String var1);

        public Builder from(CreateRelationshipRequest var1);
    }
}

