/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.tests.flows;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.tests.flows.AsyncRawFlowsClient;
import com.rulebricks.resources.tests.flows.requests.CreateFlowsRequest;
import com.rulebricks.resources.tests.flows.requests.DeleteFlowsRequest;
import com.rulebricks.resources.tests.flows.requests.ListFlowsRequest;
import com.rulebricks.types.Test;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncFlowsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawFlowsClient rawClient;

    public AsyncFlowsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawFlowsClient(clientOptions);
    }

    public AsyncRawFlowsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<Test>> list(String slug) {
        return this.rawClient.list(slug).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Test>> list(String slug, ListFlowsRequest request) {
        return this.rawClient.list(slug, request).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Test>> list(String slug, ListFlowsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(slug, request, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<Test> create(String slug, CreateFlowsRequest request) {
        return this.rawClient.create(slug, request).thenApply(response -> (Test)response.body());
    }

    public CompletableFuture<Test> create(String slug, CreateFlowsRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(slug, request, requestOptions).thenApply(response -> (Test)response.body());
    }

    public CompletableFuture<Test> delete(String slug, String testId) {
        return this.rawClient.delete(slug, testId).thenApply(response -> (Test)response.body());
    }

    public CompletableFuture<Test> delete(String slug, String testId, DeleteFlowsRequest request) {
        return this.rawClient.delete(slug, testId, request).thenApply(response -> (Test)response.body());
    }

    public CompletableFuture<Test> delete(String slug, String testId, DeleteFlowsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(slug, testId, request, requestOptions).thenApply(response -> (Test)response.body());
    }
}

