/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.tests.flows;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.tests.flows.RawFlowsClient;
import com.rulebricks.resources.tests.flows.requests.CreateFlowsRequest;
import com.rulebricks.resources.tests.flows.requests.DeleteFlowsRequest;
import com.rulebricks.resources.tests.flows.requests.ListFlowsRequest;
import com.rulebricks.types.Test;
import java.util.List;

public class FlowsClient {
    protected final ClientOptions clientOptions;
    private final RawFlowsClient rawClient;

    public FlowsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawFlowsClient(clientOptions);
    }

    public RawFlowsClient withRawResponse() {
        return this.rawClient;
    }

    public List<Test> list(String slug) {
        return this.rawClient.list(slug).body();
    }

    public List<Test> list(String slug, ListFlowsRequest request) {
        return this.rawClient.list(slug, request).body();
    }

    public List<Test> list(String slug, ListFlowsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(slug, request, requestOptions).body();
    }

    public Test create(String slug, CreateFlowsRequest request) {
        return this.rawClient.create(slug, request).body();
    }

    public Test create(String slug, CreateFlowsRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(slug, request, requestOptions).body();
    }

    public Test delete(String slug, String testId) {
        return this.rawClient.delete(slug, testId).body();
    }

    public Test delete(String slug, String testId, DeleteFlowsRequest request) {
        return this.rawClient.delete(slug, testId, request).body();
    }

    public Test delete(String slug, String testId, DeleteFlowsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(slug, testId, request, requestOptions).body();
    }
}

