/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.users;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.users.AsyncRawUsersClient;
import com.rulebricks.resources.users.groups.AsyncGroupsClient;
import com.rulebricks.resources.users.requests.CreateUserRequest;
import com.rulebricks.resources.users.requests.UserInviteRequest;
import com.rulebricks.types.CreateUserResponse;
import com.rulebricks.types.UserDetail;
import com.rulebricks.types.UserInviteResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncUsersClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawUsersClient rawClient;
    protected final Supplier<AsyncGroupsClient> groupsClient;

    public AsyncUsersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawUsersClient(clientOptions);
        this.groupsClient = Suppliers.memoize(() -> new AsyncGroupsClient(clientOptions));
    }

    public AsyncRawUsersClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<UserInviteResponse> invite(UserInviteRequest request) {
        return this.rawClient.invite(request).thenApply(response -> (UserInviteResponse)response.body());
    }

    public CompletableFuture<UserInviteResponse> invite(UserInviteRequest request, RequestOptions requestOptions) {
        return this.rawClient.invite(request, requestOptions).thenApply(response -> (UserInviteResponse)response.body());
    }

    public CompletableFuture<List<UserDetail>> list() {
        return this.rawClient.list().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<UserDetail>> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<CreateUserResponse> create(CreateUserRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateUserResponse)response.body());
    }

    public CompletableFuture<CreateUserResponse> create(CreateUserRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateUserResponse)response.body());
    }

    public AsyncGroupsClient groups() {
        return this.groupsClient.get();
    }
}

