/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.users.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateUserRequest {
    private final String email;
    private final String password;
    private final Optional<String> name;
    private final Optional<String> role;
    private final Optional<List<String>> userGroups;
    private final Map<String, Object> additionalProperties;

    private CreateUserRequest(String email, String password, Optional<String> name, Optional<String> role, Optional<List<String>> userGroups, Map<String, Object> additionalProperties) {
        this.email = email;
        this.password = password;
        this.name = name;
        this.role = role;
        this.userGroups = userGroups;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="role")
    public Optional<String> getRole() {
        return this.role;
    }

    @JsonProperty(value="user_groups")
    public Optional<List<String>> getUserGroups() {
        return this.userGroups;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateUserRequest && this.equalTo((CreateUserRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateUserRequest other) {
        return this.email.equals(other.email) && this.password.equals(other.password) && this.name.equals(other.name) && this.role.equals(other.role) && this.userGroups.equals(other.userGroups);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.password, this.name, this.role, this.userGroups);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EmailStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EmailStage,
    PasswordStage,
    _FinalStage {
        private String email;
        private String password;
        private Optional<List<String>> userGroups = Optional.empty();
        private Optional<String> role = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateUserRequest other) {
            this.email(other.getEmail());
            this.password(other.getPassword());
            this.name(other.getName());
            this.role(other.getRole());
            this.userGroups(other.getUserGroups());
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public PasswordStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="password")
        public _FinalStage password(@NotNull String password) {
            this.password = Objects.requireNonNull(password, "password must not be null");
            return this;
        }

        @Override
        public _FinalStage userGroups(List<String> userGroups) {
            this.userGroups = Optional.ofNullable(userGroups);
            return this;
        }

        @Override
        @JsonSetter(value="user_groups", nulls=Nulls.SKIP)
        public _FinalStage userGroups(Optional<List<String>> userGroups) {
            this.userGroups = userGroups;
            return this;
        }

        @Override
        public _FinalStage role(String role) {
            this.role = Optional.ofNullable(role);
            return this;
        }

        @Override
        @JsonSetter(value="role", nulls=Nulls.SKIP)
        public _FinalStage role(Optional<String> role) {
            this.role = role;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this.email, this.password, this.name, this.role, this.userGroups, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateUserRequest build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage role(Optional<String> var1);

        public _FinalStage role(String var1);

        public _FinalStage userGroups(Optional<List<String>> var1);

        public _FinalStage userGroups(List<String> var1);
    }

    public static interface PasswordStage {
        public _FinalStage password(@NotNull String var1);
    }

    public static interface EmailStage {
        public PasswordStage email(@NotNull String var1);

        public Builder from(CreateUserRequest var1);
    }
}

