/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.values;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.values.AsyncRawValuesClient;
import com.rulebricks.resources.values.requests.DeleteValuesRequest;
import com.rulebricks.resources.values.requests.ListValuesRequest;
import com.rulebricks.resources.values.requests.UpdateValuesRequest;
import com.rulebricks.types.DynamicValue;
import com.rulebricks.types.SuccessMessage;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncValuesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawValuesClient rawClient;

    public AsyncValuesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawValuesClient(clientOptions);
    }

    public AsyncRawValuesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<DynamicValue>> list() {
        return this.rawClient.list().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<DynamicValue>> list(ListValuesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<DynamicValue>> list(ListValuesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<DynamicValue>> update(UpdateValuesRequest request) {
        return this.rawClient.update(request).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<DynamicValue>> update(UpdateValuesRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<SuccessMessage> delete(DeleteValuesRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (SuccessMessage)response.body());
    }

    public CompletableFuture<SuccessMessage> delete(DeleteValuesRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (SuccessMessage)response.body());
    }
}

