/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.values.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListValuesRequest {
    private final Optional<String> name;
    private final Optional<String> include;
    private final Map<String, Object> additionalProperties;

    private ListValuesRequest(Optional<String> name, Optional<String> include, Map<String, Object> additionalProperties) {
        this.name = name;
        this.include = include;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="include")
    public Optional<String> getInclude() {
        return this.include;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListValuesRequest && this.equalTo((ListValuesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListValuesRequest other) {
        return this.name.equals(other.name) && this.include.equals(other.include);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.include);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> include = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListValuesRequest other) {
            this.name(other.getName());
            this.include(other.getInclude());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="include", nulls=Nulls.SKIP)
        public Builder include(Optional<String> include) {
            this.include = include;
            return this;
        }

        public Builder include(String include) {
            this.include = Optional.ofNullable(include);
            return this;
        }

        public ListValuesRequest build() {
            return new ListValuesRequest(this.name, this.include, this.additionalProperties);
        }
    }
}

