/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.ContextBaseOnSchemaMismatch;
import com.rulebricks.types.IContextBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContextBase
implements IContextBase {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> slug;
    private final Optional<String> description;
    private final Optional<Boolean> autoExecuteDecisions;
    private final Optional<Integer> ttlSeconds;
    private final Optional<Integer> historyLimit;
    private final Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch;
    private final Optional<String> webhookOnSolve;
    private final Optional<String> webhookOnExpire;
    private final Map<String, Object> additionalProperties;

    private ContextBase(Optional<String> id, Optional<String> name, Optional<String> slug, Optional<String> description, Optional<Boolean> autoExecuteDecisions, Optional<Integer> ttlSeconds, Optional<Integer> historyLimit, Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch, Optional<String> webhookOnSolve, Optional<String> webhookOnExpire, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.slug = slug;
        this.description = description;
        this.autoExecuteDecisions = autoExecuteDecisions;
        this.ttlSeconds = ttlSeconds;
        this.historyLimit = historyLimit;
        this.onSchemaMismatch = onSchemaMismatch;
        this.webhookOnSolve = webhookOnSolve;
        this.webhookOnExpire = webhookOnExpire;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="slug")
    public Optional<String> getSlug() {
        return this.slug;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="auto_execute_decisions")
    public Optional<Boolean> getAutoExecuteDecisions() {
        return this.autoExecuteDecisions;
    }

    @Override
    @JsonIgnore
    public Optional<Integer> getTtlSeconds() {
        if (this.ttlSeconds == null) {
            return Optional.empty();
        }
        return this.ttlSeconds;
    }

    @Override
    @JsonProperty(value="history_limit")
    public Optional<Integer> getHistoryLimit() {
        return this.historyLimit;
    }

    @Override
    @JsonProperty(value="on_schema_mismatch")
    public Optional<ContextBaseOnSchemaMismatch> getOnSchemaMismatch() {
        return this.onSchemaMismatch;
    }

    @Override
    @JsonIgnore
    public Optional<String> getWebhookOnSolve() {
        if (this.webhookOnSolve == null) {
            return Optional.empty();
        }
        return this.webhookOnSolve;
    }

    @Override
    @JsonIgnore
    public Optional<String> getWebhookOnExpire() {
        if (this.webhookOnExpire == null) {
            return Optional.empty();
        }
        return this.webhookOnExpire;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ttl_seconds")
    private Optional<Integer> _getTtlSeconds() {
        return this.ttlSeconds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="webhook_on_solve")
    private Optional<String> _getWebhookOnSolve() {
        return this.webhookOnSolve;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="webhook_on_expire")
    private Optional<String> _getWebhookOnExpire() {
        return this.webhookOnExpire;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContextBase && this.equalTo((ContextBase)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContextBase other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.slug.equals(other.slug) && this.description.equals(other.description) && this.autoExecuteDecisions.equals(other.autoExecuteDecisions) && this.ttlSeconds.equals(other.ttlSeconds) && this.historyLimit.equals(other.historyLimit) && this.onSchemaMismatch.equals(other.onSchemaMismatch) && this.webhookOnSolve.equals(other.webhookOnSolve) && this.webhookOnExpire.equals(other.webhookOnExpire);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.slug, this.description, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> slug = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Boolean> autoExecuteDecisions = Optional.empty();
        private Optional<Integer> ttlSeconds = Optional.empty();
        private Optional<Integer> historyLimit = Optional.empty();
        private Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch = Optional.empty();
        private Optional<String> webhookOnSolve = Optional.empty();
        private Optional<String> webhookOnExpire = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContextBase other) {
            this.id(other.getId());
            this.name(other.getName());
            this.slug(other.getSlug());
            this.description(other.getDescription());
            this.autoExecuteDecisions(other.getAutoExecuteDecisions());
            this.ttlSeconds(other.getTtlSeconds());
            this.historyLimit(other.getHistoryLimit());
            this.onSchemaMismatch(other.getOnSchemaMismatch());
            this.webhookOnSolve(other.getWebhookOnSolve());
            this.webhookOnExpire(other.getWebhookOnExpire());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="slug", nulls=Nulls.SKIP)
        public Builder slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        public Builder slug(String slug) {
            this.slug = Optional.ofNullable(slug);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="auto_execute_decisions", nulls=Nulls.SKIP)
        public Builder autoExecuteDecisions(Optional<Boolean> autoExecuteDecisions) {
            this.autoExecuteDecisions = autoExecuteDecisions;
            return this;
        }

        public Builder autoExecuteDecisions(Boolean autoExecuteDecisions) {
            this.autoExecuteDecisions = Optional.ofNullable(autoExecuteDecisions);
            return this;
        }

        @JsonSetter(value="ttl_seconds", nulls=Nulls.SKIP)
        public Builder ttlSeconds(Optional<Integer> ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        public Builder ttlSeconds(Integer ttlSeconds) {
            this.ttlSeconds = Optional.ofNullable(ttlSeconds);
            return this;
        }

        public Builder ttlSeconds(Nullable<Integer> ttlSeconds) {
            this.ttlSeconds = ttlSeconds.isNull() ? null : (ttlSeconds.isEmpty() ? Optional.empty() : Optional.of(ttlSeconds.get()));
            return this;
        }

        @JsonSetter(value="history_limit", nulls=Nulls.SKIP)
        public Builder historyLimit(Optional<Integer> historyLimit) {
            this.historyLimit = historyLimit;
            return this;
        }

        public Builder historyLimit(Integer historyLimit) {
            this.historyLimit = Optional.ofNullable(historyLimit);
            return this;
        }

        @JsonSetter(value="on_schema_mismatch", nulls=Nulls.SKIP)
        public Builder onSchemaMismatch(Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch) {
            this.onSchemaMismatch = onSchemaMismatch;
            return this;
        }

        public Builder onSchemaMismatch(ContextBaseOnSchemaMismatch onSchemaMismatch) {
            this.onSchemaMismatch = Optional.ofNullable(onSchemaMismatch);
            return this;
        }

        @JsonSetter(value="webhook_on_solve", nulls=Nulls.SKIP)
        public Builder webhookOnSolve(Optional<String> webhookOnSolve) {
            this.webhookOnSolve = webhookOnSolve;
            return this;
        }

        public Builder webhookOnSolve(String webhookOnSolve) {
            this.webhookOnSolve = Optional.ofNullable(webhookOnSolve);
            return this;
        }

        public Builder webhookOnSolve(Nullable<String> webhookOnSolve) {
            this.webhookOnSolve = webhookOnSolve.isNull() ? null : (webhookOnSolve.isEmpty() ? Optional.empty() : Optional.of(webhookOnSolve.get()));
            return this;
        }

        @JsonSetter(value="webhook_on_expire", nulls=Nulls.SKIP)
        public Builder webhookOnExpire(Optional<String> webhookOnExpire) {
            this.webhookOnExpire = webhookOnExpire;
            return this;
        }

        public Builder webhookOnExpire(String webhookOnExpire) {
            this.webhookOnExpire = Optional.ofNullable(webhookOnExpire);
            return this;
        }

        public Builder webhookOnExpire(Nullable<String> webhookOnExpire) {
            this.webhookOnExpire = webhookOnExpire.isNull() ? null : (webhookOnExpire.isEmpty() ? Optional.empty() : Optional.of(webhookOnExpire.get()));
            return this;
        }

        public ContextBase build() {
            return new ContextBase(this.id, this.name, this.slug, this.description, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire, this.additionalProperties);
        }
    }
}

