/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.ContextBaseOnSchemaMismatch;
import com.rulebricks.types.ContextDetailBoundFlowsItem;
import com.rulebricks.types.ContextDetailBoundRulesItem;
import com.rulebricks.types.ContextDetailFolder;
import com.rulebricks.types.ContextDetailRelationships;
import com.rulebricks.types.ContextSchema;
import com.rulebricks.types.IContextBase;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContextDetail
implements IContextBase {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> slug;
    private final Optional<String> description;
    private final Optional<Boolean> autoExecuteDecisions;
    private final Optional<Integer> ttlSeconds;
    private final Optional<Integer> historyLimit;
    private final Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch;
    private final Optional<String> webhookOnSolve;
    private final Optional<String> webhookOnExpire;
    private final Optional<ContextSchema> schema;
    private final Optional<String> identityFact;
    private final Optional<List<String>> userGroups;
    private final Optional<ContextDetailFolder> folder;
    private final Optional<List<ContextDetailBoundRulesItem>> boundRules;
    private final Optional<List<ContextDetailBoundFlowsItem>> boundFlows;
    private final Optional<ContextDetailRelationships> relationships;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> updatedAt;
    private final Map<String, Object> additionalProperties;

    private ContextDetail(Optional<String> id, Optional<String> name, Optional<String> slug, Optional<String> description, Optional<Boolean> autoExecuteDecisions, Optional<Integer> ttlSeconds, Optional<Integer> historyLimit, Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch, Optional<String> webhookOnSolve, Optional<String> webhookOnExpire, Optional<ContextSchema> schema, Optional<String> identityFact, Optional<List<String>> userGroups, Optional<ContextDetailFolder> folder, Optional<List<ContextDetailBoundRulesItem>> boundRules, Optional<List<ContextDetailBoundFlowsItem>> boundFlows, Optional<ContextDetailRelationships> relationships, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.slug = slug;
        this.description = description;
        this.autoExecuteDecisions = autoExecuteDecisions;
        this.ttlSeconds = ttlSeconds;
        this.historyLimit = historyLimit;
        this.onSchemaMismatch = onSchemaMismatch;
        this.webhookOnSolve = webhookOnSolve;
        this.webhookOnExpire = webhookOnExpire;
        this.schema = schema;
        this.identityFact = identityFact;
        this.userGroups = userGroups;
        this.folder = folder;
        this.boundRules = boundRules;
        this.boundFlows = boundFlows;
        this.relationships = relationships;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="slug")
    public Optional<String> getSlug() {
        return this.slug;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="auto_execute_decisions")
    public Optional<Boolean> getAutoExecuteDecisions() {
        return this.autoExecuteDecisions;
    }

    @Override
    @JsonIgnore
    public Optional<Integer> getTtlSeconds() {
        if (this.ttlSeconds == null) {
            return Optional.empty();
        }
        return this.ttlSeconds;
    }

    @Override
    @JsonProperty(value="history_limit")
    public Optional<Integer> getHistoryLimit() {
        return this.historyLimit;
    }

    @Override
    @JsonProperty(value="on_schema_mismatch")
    public Optional<ContextBaseOnSchemaMismatch> getOnSchemaMismatch() {
        return this.onSchemaMismatch;
    }

    @Override
    @JsonIgnore
    public Optional<String> getWebhookOnSolve() {
        if (this.webhookOnSolve == null) {
            return Optional.empty();
        }
        return this.webhookOnSolve;
    }

    @Override
    @JsonIgnore
    public Optional<String> getWebhookOnExpire() {
        if (this.webhookOnExpire == null) {
            return Optional.empty();
        }
        return this.webhookOnExpire;
    }

    @JsonProperty(value="schema")
    public Optional<ContextSchema> getSchema() {
        return this.schema;
    }

    @JsonIgnore
    public Optional<String> getIdentityFact() {
        if (this.identityFact == null) {
            return Optional.empty();
        }
        return this.identityFact;
    }

    @JsonIgnore
    public Optional<List<String>> getUserGroups() {
        if (this.userGroups == null) {
            return Optional.empty();
        }
        return this.userGroups;
    }

    @JsonIgnore
    public Optional<ContextDetailFolder> getFolder() {
        if (this.folder == null) {
            return Optional.empty();
        }
        return this.folder;
    }

    @JsonProperty(value="bound_rules")
    public Optional<List<ContextDetailBoundRulesItem>> getBoundRules() {
        return this.boundRules;
    }

    @JsonProperty(value="bound_flows")
    public Optional<List<ContextDetailBoundFlowsItem>> getBoundFlows() {
        return this.boundFlows;
    }

    @JsonProperty(value="relationships")
    public Optional<ContextDetailRelationships> getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<OffsetDateTime> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ttl_seconds")
    private Optional<Integer> _getTtlSeconds() {
        return this.ttlSeconds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="webhook_on_solve")
    private Optional<String> _getWebhookOnSolve() {
        return this.webhookOnSolve;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="webhook_on_expire")
    private Optional<String> _getWebhookOnExpire() {
        return this.webhookOnExpire;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="identity_fact")
    private Optional<String> _getIdentityFact() {
        return this.identityFact;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="user_groups")
    private Optional<List<String>> _getUserGroups() {
        return this.userGroups;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="folder")
    private Optional<ContextDetailFolder> _getFolder() {
        return this.folder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContextDetail && this.equalTo((ContextDetail)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContextDetail other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.slug.equals(other.slug) && this.description.equals(other.description) && this.autoExecuteDecisions.equals(other.autoExecuteDecisions) && this.ttlSeconds.equals(other.ttlSeconds) && this.historyLimit.equals(other.historyLimit) && this.onSchemaMismatch.equals(other.onSchemaMismatch) && this.webhookOnSolve.equals(other.webhookOnSolve) && this.webhookOnExpire.equals(other.webhookOnExpire) && this.schema.equals(other.schema) && this.identityFact.equals(other.identityFact) && this.userGroups.equals(other.userGroups) && this.folder.equals(other.folder) && this.boundRules.equals(other.boundRules) && this.boundFlows.equals(other.boundFlows) && this.relationships.equals(other.relationships) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.slug, this.description, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire, this.schema, this.identityFact, this.userGroups, this.folder, this.boundRules, this.boundFlows, this.relationships, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> slug = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Boolean> autoExecuteDecisions = Optional.empty();
        private Optional<Integer> ttlSeconds = Optional.empty();
        private Optional<Integer> historyLimit = Optional.empty();
        private Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch = Optional.empty();
        private Optional<String> webhookOnSolve = Optional.empty();
        private Optional<String> webhookOnExpire = Optional.empty();
        private Optional<ContextSchema> schema = Optional.empty();
        private Optional<String> identityFact = Optional.empty();
        private Optional<List<String>> userGroups = Optional.empty();
        private Optional<ContextDetailFolder> folder = Optional.empty();
        private Optional<List<ContextDetailBoundRulesItem>> boundRules = Optional.empty();
        private Optional<List<ContextDetailBoundFlowsItem>> boundFlows = Optional.empty();
        private Optional<ContextDetailRelationships> relationships = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContextDetail other) {
            this.id(other.getId());
            this.name(other.getName());
            this.slug(other.getSlug());
            this.description(other.getDescription());
            this.autoExecuteDecisions(other.getAutoExecuteDecisions());
            this.ttlSeconds(other.getTtlSeconds());
            this.historyLimit(other.getHistoryLimit());
            this.onSchemaMismatch(other.getOnSchemaMismatch());
            this.webhookOnSolve(other.getWebhookOnSolve());
            this.webhookOnExpire(other.getWebhookOnExpire());
            this.schema(other.getSchema());
            this.identityFact(other.getIdentityFact());
            this.userGroups(other.getUserGroups());
            this.folder(other.getFolder());
            this.boundRules(other.getBoundRules());
            this.boundFlows(other.getBoundFlows());
            this.relationships(other.getRelationships());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="slug", nulls=Nulls.SKIP)
        public Builder slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        public Builder slug(String slug) {
            this.slug = Optional.ofNullable(slug);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="auto_execute_decisions", nulls=Nulls.SKIP)
        public Builder autoExecuteDecisions(Optional<Boolean> autoExecuteDecisions) {
            this.autoExecuteDecisions = autoExecuteDecisions;
            return this;
        }

        public Builder autoExecuteDecisions(Boolean autoExecuteDecisions) {
            this.autoExecuteDecisions = Optional.ofNullable(autoExecuteDecisions);
            return this;
        }

        @JsonSetter(value="ttl_seconds", nulls=Nulls.SKIP)
        public Builder ttlSeconds(Optional<Integer> ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        public Builder ttlSeconds(Integer ttlSeconds) {
            this.ttlSeconds = Optional.ofNullable(ttlSeconds);
            return this;
        }

        public Builder ttlSeconds(Nullable<Integer> ttlSeconds) {
            this.ttlSeconds = ttlSeconds.isNull() ? null : (ttlSeconds.isEmpty() ? Optional.empty() : Optional.of(ttlSeconds.get()));
            return this;
        }

        @JsonSetter(value="history_limit", nulls=Nulls.SKIP)
        public Builder historyLimit(Optional<Integer> historyLimit) {
            this.historyLimit = historyLimit;
            return this;
        }

        public Builder historyLimit(Integer historyLimit) {
            this.historyLimit = Optional.ofNullable(historyLimit);
            return this;
        }

        @JsonSetter(value="on_schema_mismatch", nulls=Nulls.SKIP)
        public Builder onSchemaMismatch(Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch) {
            this.onSchemaMismatch = onSchemaMismatch;
            return this;
        }

        public Builder onSchemaMismatch(ContextBaseOnSchemaMismatch onSchemaMismatch) {
            this.onSchemaMismatch = Optional.ofNullable(onSchemaMismatch);
            return this;
        }

        @JsonSetter(value="webhook_on_solve", nulls=Nulls.SKIP)
        public Builder webhookOnSolve(Optional<String> webhookOnSolve) {
            this.webhookOnSolve = webhookOnSolve;
            return this;
        }

        public Builder webhookOnSolve(String webhookOnSolve) {
            this.webhookOnSolve = Optional.ofNullable(webhookOnSolve);
            return this;
        }

        public Builder webhookOnSolve(Nullable<String> webhookOnSolve) {
            this.webhookOnSolve = webhookOnSolve.isNull() ? null : (webhookOnSolve.isEmpty() ? Optional.empty() : Optional.of(webhookOnSolve.get()));
            return this;
        }

        @JsonSetter(value="webhook_on_expire", nulls=Nulls.SKIP)
        public Builder webhookOnExpire(Optional<String> webhookOnExpire) {
            this.webhookOnExpire = webhookOnExpire;
            return this;
        }

        public Builder webhookOnExpire(String webhookOnExpire) {
            this.webhookOnExpire = Optional.ofNullable(webhookOnExpire);
            return this;
        }

        public Builder webhookOnExpire(Nullable<String> webhookOnExpire) {
            this.webhookOnExpire = webhookOnExpire.isNull() ? null : (webhookOnExpire.isEmpty() ? Optional.empty() : Optional.of(webhookOnExpire.get()));
            return this;
        }

        @JsonSetter(value="schema", nulls=Nulls.SKIP)
        public Builder schema(Optional<ContextSchema> schema) {
            this.schema = schema;
            return this;
        }

        public Builder schema(ContextSchema schema) {
            this.schema = Optional.ofNullable(schema);
            return this;
        }

        @JsonSetter(value="identity_fact", nulls=Nulls.SKIP)
        public Builder identityFact(Optional<String> identityFact) {
            this.identityFact = identityFact;
            return this;
        }

        public Builder identityFact(String identityFact) {
            this.identityFact = Optional.ofNullable(identityFact);
            return this;
        }

        public Builder identityFact(Nullable<String> identityFact) {
            this.identityFact = identityFact.isNull() ? null : (identityFact.isEmpty() ? Optional.empty() : Optional.of(identityFact.get()));
            return this;
        }

        @JsonSetter(value="user_groups", nulls=Nulls.SKIP)
        public Builder userGroups(Optional<List<String>> userGroups) {
            this.userGroups = userGroups;
            return this;
        }

        public Builder userGroups(List<String> userGroups) {
            this.userGroups = Optional.ofNullable(userGroups);
            return this;
        }

        public Builder userGroups(Nullable<List<String>> userGroups) {
            this.userGroups = userGroups.isNull() ? null : (userGroups.isEmpty() ? Optional.empty() : Optional.of(userGroups.get()));
            return this;
        }

        @JsonSetter(value="folder", nulls=Nulls.SKIP)
        public Builder folder(Optional<ContextDetailFolder> folder) {
            this.folder = folder;
            return this;
        }

        public Builder folder(ContextDetailFolder folder) {
            this.folder = Optional.ofNullable(folder);
            return this;
        }

        public Builder folder(Nullable<ContextDetailFolder> folder) {
            this.folder = folder.isNull() ? null : (folder.isEmpty() ? Optional.empty() : Optional.of(folder.get()));
            return this;
        }

        @JsonSetter(value="bound_rules", nulls=Nulls.SKIP)
        public Builder boundRules(Optional<List<ContextDetailBoundRulesItem>> boundRules) {
            this.boundRules = boundRules;
            return this;
        }

        public Builder boundRules(List<ContextDetailBoundRulesItem> boundRules) {
            this.boundRules = Optional.ofNullable(boundRules);
            return this;
        }

        @JsonSetter(value="bound_flows", nulls=Nulls.SKIP)
        public Builder boundFlows(Optional<List<ContextDetailBoundFlowsItem>> boundFlows) {
            this.boundFlows = boundFlows;
            return this;
        }

        public Builder boundFlows(List<ContextDetailBoundFlowsItem> boundFlows) {
            this.boundFlows = Optional.ofNullable(boundFlows);
            return this;
        }

        @JsonSetter(value="relationships", nulls=Nulls.SKIP)
        public Builder relationships(Optional<ContextDetailRelationships> relationships) {
            this.relationships = relationships;
            return this;
        }

        public Builder relationships(ContextDetailRelationships relationships) {
            this.relationships = Optional.ofNullable(relationships);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public ContextDetail build() {
            return new ContextDetail(this.id, this.name, this.slug, this.description, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire, this.schema, this.identityFact, this.userGroups, this.folder, this.boundRules, this.boundFlows, this.relationships, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

