/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.ContextInstanceHistoryEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContextInstanceHistory {
    private final Optional<String> context;
    private final Optional<Map<String, List<ContextInstanceHistoryEntry>>> history;
    private final Map<String, Object> additionalProperties;

    private ContextInstanceHistory(Optional<String> context, Optional<Map<String, List<ContextInstanceHistoryEntry>>> history, Map<String, Object> additionalProperties) {
        this.context = context;
        this.history = history;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="context")
    public Optional<String> getContext() {
        return this.context;
    }

    @JsonProperty(value="history")
    public Optional<Map<String, List<ContextInstanceHistoryEntry>>> getHistory() {
        return this.history;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContextInstanceHistory && this.equalTo((ContextInstanceHistory)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContextInstanceHistory other) {
        return this.context.equals(other.context) && this.history.equals(other.history);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.history);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> context = Optional.empty();
        private Optional<Map<String, List<ContextInstanceHistoryEntry>>> history = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContextInstanceHistory other) {
            this.context(other.getContext());
            this.history(other.getHistory());
            return this;
        }

        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public Builder context(Optional<String> context) {
            this.context = context;
            return this;
        }

        public Builder context(String context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        @JsonSetter(value="history", nulls=Nulls.SKIP)
        public Builder history(Optional<Map<String, List<ContextInstanceHistoryEntry>>> history) {
            this.history = history;
            return this;
        }

        public Builder history(Map<String, List<ContextInstanceHistoryEntry>> history) {
            this.history = Optional.ofNullable(history);
            return this;
        }

        public ContextInstanceHistory build() {
            return new ContextInstanceHistory(this.context, this.history, this.additionalProperties);
        }
    }
}

