/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContextInstanceHistoryEntry {
    private final Optional<OffsetDateTime> timestamp;
    private final Optional<Object> value;
    private final Map<String, Object> additionalProperties;

    private ContextInstanceHistoryEntry(Optional<OffsetDateTime> timestamp, Optional<Object> value, Map<String, Object> additionalProperties) {
        this.timestamp = timestamp;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="timestamp")
    public Optional<OffsetDateTime> getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="value")
    public Optional<Object> getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContextInstanceHistoryEntry && this.equalTo((ContextInstanceHistoryEntry)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContextInstanceHistoryEntry other) {
        return this.timestamp.equals(other.timestamp) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> timestamp = Optional.empty();
        private Optional<Object> value = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContextInstanceHistoryEntry other) {
            this.timestamp(other.getTimestamp());
            this.value(other.getValue());
            return this;
        }

        @JsonSetter(value="timestamp", nulls=Nulls.SKIP)
        public Builder timestamp(Optional<OffsetDateTime> timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            this.timestamp = Optional.ofNullable(timestamp);
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<Object> value) {
            this.value = value;
            return this;
        }

        public Builder value(Object value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public ContextInstanceHistoryEntry build() {
            return new ContextInstanceHistoryEntry(this.timestamp, this.value, this.additionalProperties);
        }
    }
}

