/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.ContextInstancePendingEvaluationType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContextInstancePendingEvaluation {
    private final Optional<ContextInstancePendingEvaluationType> type;
    private final Optional<String> rule;
    private final Optional<String> ruleId;
    private final Optional<String> flow;
    private final Optional<String> flowId;
    private final Optional<List<String>> waitingOn;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> expiresAt;
    private final Map<String, Object> additionalProperties;

    private ContextInstancePendingEvaluation(Optional<ContextInstancePendingEvaluationType> type, Optional<String> rule, Optional<String> ruleId, Optional<String> flow, Optional<String> flowId, Optional<List<String>> waitingOn, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> expiresAt, Map<String, Object> additionalProperties) {
        this.type = type;
        this.rule = rule;
        this.ruleId = ruleId;
        this.flow = flow;
        this.flowId = flowId;
        this.waitingOn = waitingOn;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<ContextInstancePendingEvaluationType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getRule() {
        if (this.rule == null) {
            return Optional.empty();
        }
        return this.rule;
    }

    @JsonIgnore
    public Optional<String> getRuleId() {
        if (this.ruleId == null) {
            return Optional.empty();
        }
        return this.ruleId;
    }

    @JsonIgnore
    public Optional<String> getFlow() {
        if (this.flow == null) {
            return Optional.empty();
        }
        return this.flow;
    }

    @JsonIgnore
    public Optional<String> getFlowId() {
        if (this.flowId == null) {
            return Optional.empty();
        }
        return this.flowId;
    }

    @JsonProperty(value="waiting_on")
    public Optional<List<String>> getWaitingOn() {
        return this.waitingOn;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="expires_at")
    public Optional<OffsetDateTime> getExpiresAt() {
        return this.expiresAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="rule")
    private Optional<String> _getRule() {
        return this.rule;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="rule_id")
    private Optional<String> _getRuleId() {
        return this.ruleId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="flow")
    private Optional<String> _getFlow() {
        return this.flow;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="flow_id")
    private Optional<String> _getFlowId() {
        return this.flowId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContextInstancePendingEvaluation && this.equalTo((ContextInstancePendingEvaluation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContextInstancePendingEvaluation other) {
        return this.type.equals(other.type) && this.rule.equals(other.rule) && this.ruleId.equals(other.ruleId) && this.flow.equals(other.flow) && this.flowId.equals(other.flowId) && this.waitingOn.equals(other.waitingOn) && this.createdAt.equals(other.createdAt) && this.expiresAt.equals(other.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.rule, this.ruleId, this.flow, this.flowId, this.waitingOn, this.createdAt, this.expiresAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ContextInstancePendingEvaluationType> type = Optional.empty();
        private Optional<String> rule = Optional.empty();
        private Optional<String> ruleId = Optional.empty();
        private Optional<String> flow = Optional.empty();
        private Optional<String> flowId = Optional.empty();
        private Optional<List<String>> waitingOn = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> expiresAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContextInstancePendingEvaluation other) {
            this.type(other.getType());
            this.rule(other.getRule());
            this.ruleId(other.getRuleId());
            this.flow(other.getFlow());
            this.flowId(other.getFlowId());
            this.waitingOn(other.getWaitingOn());
            this.createdAt(other.getCreatedAt());
            this.expiresAt(other.getExpiresAt());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<ContextInstancePendingEvaluationType> type) {
            this.type = type;
            return this;
        }

        public Builder type(ContextInstancePendingEvaluationType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="rule", nulls=Nulls.SKIP)
        public Builder rule(Optional<String> rule) {
            this.rule = rule;
            return this;
        }

        public Builder rule(String rule) {
            this.rule = Optional.ofNullable(rule);
            return this;
        }

        public Builder rule(Nullable<String> rule) {
            this.rule = rule.isNull() ? null : (rule.isEmpty() ? Optional.empty() : Optional.of(rule.get()));
            return this;
        }

        @JsonSetter(value="rule_id", nulls=Nulls.SKIP)
        public Builder ruleId(Optional<String> ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder ruleId(String ruleId) {
            this.ruleId = Optional.ofNullable(ruleId);
            return this;
        }

        public Builder ruleId(Nullable<String> ruleId) {
            this.ruleId = ruleId.isNull() ? null : (ruleId.isEmpty() ? Optional.empty() : Optional.of(ruleId.get()));
            return this;
        }

        @JsonSetter(value="flow", nulls=Nulls.SKIP)
        public Builder flow(Optional<String> flow) {
            this.flow = flow;
            return this;
        }

        public Builder flow(String flow) {
            this.flow = Optional.ofNullable(flow);
            return this;
        }

        public Builder flow(Nullable<String> flow) {
            this.flow = flow.isNull() ? null : (flow.isEmpty() ? Optional.empty() : Optional.of(flow.get()));
            return this;
        }

        @JsonSetter(value="flow_id", nulls=Nulls.SKIP)
        public Builder flowId(Optional<String> flowId) {
            this.flowId = flowId;
            return this;
        }

        public Builder flowId(String flowId) {
            this.flowId = Optional.ofNullable(flowId);
            return this;
        }

        public Builder flowId(Nullable<String> flowId) {
            this.flowId = flowId.isNull() ? null : (flowId.isEmpty() ? Optional.empty() : Optional.of(flowId.get()));
            return this;
        }

        @JsonSetter(value="waiting_on", nulls=Nulls.SKIP)
        public Builder waitingOn(Optional<List<String>> waitingOn) {
            this.waitingOn = waitingOn;
            return this;
        }

        public Builder waitingOn(List<String> waitingOn) {
            this.waitingOn = Optional.ofNullable(waitingOn);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public Builder expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        public ContextInstancePendingEvaluation build() {
            return new ContextInstancePendingEvaluation(this.type, this.rule, this.ruleId, this.flow, this.flowId, this.waitingOn, this.createdAt, this.expiresAt, this.additionalProperties);
        }
    }
}

