/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteContextInstanceResponse {
    private final Optional<String> message;
    private final Optional<Integer> pendingEvaluationsCancelled;
    private final Map<String, Object> additionalProperties;

    private DeleteContextInstanceResponse(Optional<String> message, Optional<Integer> pendingEvaluationsCancelled, Map<String, Object> additionalProperties) {
        this.message = message;
        this.pendingEvaluationsCancelled = pendingEvaluationsCancelled;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message")
    public Optional<String> getMessage() {
        return this.message;
    }

    @JsonProperty(value="pending_evaluations_cancelled")
    public Optional<Integer> getPendingEvaluationsCancelled() {
        return this.pendingEvaluationsCancelled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteContextInstanceResponse && this.equalTo((DeleteContextInstanceResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteContextInstanceResponse other) {
        return this.message.equals(other.message) && this.pendingEvaluationsCancelled.equals(other.pendingEvaluationsCancelled);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.pendingEvaluationsCancelled);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> message = Optional.empty();
        private Optional<Integer> pendingEvaluationsCancelled = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeleteContextInstanceResponse other) {
            this.message(other.getMessage());
            this.pendingEvaluationsCancelled(other.getPendingEvaluationsCancelled());
            return this;
        }

        @JsonSetter(value="message", nulls=Nulls.SKIP)
        public Builder message(Optional<String> message) {
            this.message = message;
            return this;
        }

        public Builder message(String message) {
            this.message = Optional.ofNullable(message);
            return this;
        }

        @JsonSetter(value="pending_evaluations_cancelled", nulls=Nulls.SKIP)
        public Builder pendingEvaluationsCancelled(Optional<Integer> pendingEvaluationsCancelled) {
            this.pendingEvaluationsCancelled = pendingEvaluationsCancelled;
            return this;
        }

        public Builder pendingEvaluationsCancelled(Integer pendingEvaluationsCancelled) {
            this.pendingEvaluationsCancelled = Optional.ofNullable(pendingEvaluationsCancelled);
            return this;
        }

        public DeleteContextInstanceResponse build() {
            return new DeleteContextInstanceResponse(this.message, this.pendingEvaluationsCancelled, this.additionalProperties);
        }
    }
}

