/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.DynamicValueValue;
import com.rulebricks.types.RuleUsage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DynamicValue {
    private final String id;
    private final String name;
    private final String type;
    private final Optional<DynamicValueValue> value;
    private final Optional<List<RuleUsage>> usages;
    private final Optional<List<String>> userGroups;
    private final Map<String, Object> additionalProperties;

    private DynamicValue(String id, String name, String type, Optional<DynamicValueValue> value, Optional<List<RuleUsage>> usages, Optional<List<String>> userGroups, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.value = value;
        this.usages = usages;
        this.userGroups = userGroups;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="value")
    public Optional<DynamicValueValue> getValue() {
        return this.value;
    }

    @JsonProperty(value="usages")
    public Optional<List<RuleUsage>> getUsages() {
        return this.usages;
    }

    @JsonProperty(value="user_groups")
    public Optional<List<String>> getUserGroups() {
        return this.userGroups;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DynamicValue && this.equalTo((DynamicValue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DynamicValue other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.type.equals(other.type) && this.value.equals(other.value) && this.usages.equals(other.usages) && this.userGroups.equals(other.userGroups);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.type, this.value, this.usages, this.userGroups);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    TypeStage,
    _FinalStage {
        private String id;
        private String name;
        private String type;
        private Optional<List<String>> userGroups = Optional.empty();
        private Optional<List<RuleUsage>> usages = Optional.empty();
        private Optional<DynamicValueValue> value = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DynamicValue other) {
            this.id(other.getId());
            this.name(other.getName());
            this.type(other.getType());
            this.value(other.getValue());
            this.usages(other.getUsages());
            this.userGroups(other.getUserGroups());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public TypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage userGroups(List<String> userGroups) {
            this.userGroups = Optional.ofNullable(userGroups);
            return this;
        }

        @Override
        @JsonSetter(value="user_groups", nulls=Nulls.SKIP)
        public _FinalStage userGroups(Optional<List<String>> userGroups) {
            this.userGroups = userGroups;
            return this;
        }

        @Override
        public _FinalStage usages(List<RuleUsage> usages) {
            this.usages = Optional.ofNullable(usages);
            return this;
        }

        @Override
        @JsonSetter(value="usages", nulls=Nulls.SKIP)
        public _FinalStage usages(Optional<List<RuleUsage>> usages) {
            this.usages = usages;
            return this;
        }

        @Override
        public _FinalStage value(DynamicValueValue value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @Override
        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public _FinalStage value(Optional<DynamicValueValue> value) {
            this.value = value;
            return this;
        }

        @Override
        public DynamicValue build() {
            return new DynamicValue(this.id, this.name, this.type, this.value, this.usages, this.userGroups, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DynamicValue build();

        public _FinalStage value(Optional<DynamicValueValue> var1);

        public _FinalStage value(DynamicValueValue var1);

        public _FinalStage usages(Optional<List<RuleUsage>> var1);

        public _FinalStage usages(List<RuleUsage> var1);

        public _FinalStage userGroups(Optional<List<String>> var1);

        public _FinalStage userGroups(List<String> var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull String var1);
    }

    public static interface NameStage {
        public TypeStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(DynamicValue var1);
    }
}

