/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.rulebricks.core.ObjectMappers;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class DynamicValueValue {
    private final Object value;
    private final int type;

    private DynamicValueValue(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((String)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((Double)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((Boolean)this.value);
        }
        if (this.type == 3) {
            return visitor.visit((List)this.value);
        }
        if (this.type == 4) {
            return visitor.visit((Map)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DynamicValueValue && this.equalTo((DynamicValueValue)other);
    }

    private boolean equalTo(DynamicValueValue other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static DynamicValueValue of(String value) {
        return new DynamicValueValue(value, 0);
    }

    public static DynamicValueValue of(double value) {
        return new DynamicValueValue(value, 1);
    }

    public static DynamicValueValue of(boolean value) {
        return new DynamicValueValue(value, 2);
    }

    public static DynamicValueValue of(List<Object> value) {
        return new DynamicValueValue(value, 3);
    }

    public static DynamicValueValue of(Map<String, Object> value) {
        return new DynamicValueValue(value, 4);
    }

    static final class Deserializer
    extends StdDeserializer<DynamicValueValue> {
        Deserializer() {
            super(DynamicValueValue.class);
        }

        public DynamicValueValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return DynamicValueValue.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
            }
            catch (RuntimeException runtimeException) {
                if (value instanceof Double) {
                    return DynamicValueValue.of((Double)value);
                }
                if (value instanceof Boolean) {
                    return DynamicValueValue.of((Boolean)value);
                }
                try {
                    return DynamicValueValue.of((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<Object>>(){}));
                }
                catch (RuntimeException runtimeException2) {
                    try {
                        return DynamicValueValue.of((Map)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                    }
                    catch (RuntimeException runtimeException3) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(String var1);

        public T visit(double var1);

        public T visit(boolean var1);

        public T visit(List<Object> var1);

        public T visit(Map<String, Object> var1);
    }
}

