/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ExportManifestResponse {
    private final Optional<String> version;
    private final Optional<OffsetDateTime> exportedAt;
    private final Optional<List<Map<String, Object>>> rules;
    private final Optional<List<Map<String, Object>>> flows;
    private final Optional<List<Map<String, Object>>> contexts;
    private final Optional<List<Map<String, Object>>> values;
    private final Map<String, Object> additionalProperties;

    private ExportManifestResponse(Optional<String> version, Optional<OffsetDateTime> exportedAt, Optional<List<Map<String, Object>>> rules, Optional<List<Map<String, Object>>> flows, Optional<List<Map<String, Object>>> contexts, Optional<List<Map<String, Object>>> values, Map<String, Object> additionalProperties) {
        this.version = version;
        this.exportedAt = exportedAt;
        this.rules = rules;
        this.flows = flows;
        this.contexts = contexts;
        this.values = values;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @JsonProperty(value="exported_at")
    public Optional<OffsetDateTime> getExportedAt() {
        return this.exportedAt;
    }

    @JsonProperty(value="rules")
    public Optional<List<Map<String, Object>>> getRules() {
        return this.rules;
    }

    @JsonProperty(value="flows")
    public Optional<List<Map<String, Object>>> getFlows() {
        return this.flows;
    }

    @JsonProperty(value="contexts")
    public Optional<List<Map<String, Object>>> getContexts() {
        return this.contexts;
    }

    @JsonProperty(value="values")
    public Optional<List<Map<String, Object>>> getValues() {
        return this.values;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExportManifestResponse && this.equalTo((ExportManifestResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExportManifestResponse other) {
        return this.version.equals(other.version) && this.exportedAt.equals(other.exportedAt) && this.rules.equals(other.rules) && this.flows.equals(other.flows) && this.contexts.equals(other.contexts) && this.values.equals(other.values);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.exportedAt, this.rules, this.flows, this.contexts, this.values);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> version = Optional.empty();
        private Optional<OffsetDateTime> exportedAt = Optional.empty();
        private Optional<List<Map<String, Object>>> rules = Optional.empty();
        private Optional<List<Map<String, Object>>> flows = Optional.empty();
        private Optional<List<Map<String, Object>>> contexts = Optional.empty();
        private Optional<List<Map<String, Object>>> values = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ExportManifestResponse other) {
            this.version(other.getVersion());
            this.exportedAt(other.getExportedAt());
            this.rules(other.getRules());
            this.flows(other.getFlows());
            this.contexts(other.getContexts());
            this.values(other.getValues());
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<String> version) {
            this.version = version;
            return this;
        }

        public Builder version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="exported_at", nulls=Nulls.SKIP)
        public Builder exportedAt(Optional<OffsetDateTime> exportedAt) {
            this.exportedAt = exportedAt;
            return this;
        }

        public Builder exportedAt(OffsetDateTime exportedAt) {
            this.exportedAt = Optional.ofNullable(exportedAt);
            return this;
        }

        @JsonSetter(value="rules", nulls=Nulls.SKIP)
        public Builder rules(Optional<List<Map<String, Object>>> rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(List<Map<String, Object>> rules) {
            this.rules = Optional.ofNullable(rules);
            return this;
        }

        @JsonSetter(value="flows", nulls=Nulls.SKIP)
        public Builder flows(Optional<List<Map<String, Object>>> flows) {
            this.flows = flows;
            return this;
        }

        public Builder flows(List<Map<String, Object>> flows) {
            this.flows = Optional.ofNullable(flows);
            return this;
        }

        @JsonSetter(value="contexts", nulls=Nulls.SKIP)
        public Builder contexts(Optional<List<Map<String, Object>>> contexts) {
            this.contexts = contexts;
            return this;
        }

        public Builder contexts(List<Map<String, Object>> contexts) {
            this.contexts = Optional.ofNullable(contexts);
            return this;
        }

        @JsonSetter(value="values", nulls=Nulls.SKIP)
        public Builder values(Optional<List<Map<String, Object>>> values) {
            this.values = values;
            return this;
        }

        public Builder values(List<Map<String, Object>> values) {
            this.values = Optional.ofNullable(values);
            return this;
        }

        public ExportManifestResponse build() {
            return new ExportManifestResponse(this.version, this.exportedAt, this.rules, this.flows, this.contexts, this.values, this.additionalProperties);
        }
    }
}

