/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.FlowDetailContext;
import com.rulebricks.types.FlowDetailOriginRule;
import com.rulebricks.types.IFlowBase;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FlowDetail
implements IFlowBase {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<String> slug;
    private final Optional<Boolean> published;
    private final Optional<OffsetDateTime> updatedAt;
    private final Optional<FlowDetailOriginRule> originRule;
    private final Optional<FlowDetailContext> context;
    private final Map<String, Object> additionalProperties;

    private FlowDetail(Optional<String> id, Optional<String> name, Optional<String> description, Optional<String> slug, Optional<Boolean> published, Optional<OffsetDateTime> updatedAt, Optional<FlowDetailOriginRule> originRule, Optional<FlowDetailContext> context, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.slug = slug;
        this.published = published;
        this.updatedAt = updatedAt;
        this.originRule = originRule;
        this.context = context;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="slug")
    public Optional<String> getSlug() {
        return this.slug;
    }

    @JsonProperty(value="published")
    public Optional<Boolean> getPublished() {
        return this.published;
    }

    @JsonProperty(value="updated_at")
    public Optional<OffsetDateTime> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<FlowDetailOriginRule> getOriginRule() {
        if (this.originRule == null) {
            return Optional.empty();
        }
        return this.originRule;
    }

    @JsonIgnore
    public Optional<FlowDetailContext> getContext() {
        if (this.context == null) {
            return Optional.empty();
        }
        return this.context;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="origin_rule")
    private Optional<FlowDetailOriginRule> _getOriginRule() {
        return this.originRule;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="context")
    private Optional<FlowDetailContext> _getContext() {
        return this.context;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FlowDetail && this.equalTo((FlowDetail)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FlowDetail other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.description.equals(other.description) && this.slug.equals(other.slug) && this.published.equals(other.published) && this.updatedAt.equals(other.updatedAt) && this.originRule.equals(other.originRule) && this.context.equals(other.context);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.slug, this.published, this.updatedAt, this.originRule, this.context);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> slug = Optional.empty();
        private Optional<Boolean> published = Optional.empty();
        private Optional<OffsetDateTime> updatedAt = Optional.empty();
        private Optional<FlowDetailOriginRule> originRule = Optional.empty();
        private Optional<FlowDetailContext> context = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FlowDetail other) {
            this.id(other.getId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.slug(other.getSlug());
            this.published(other.getPublished());
            this.updatedAt(other.getUpdatedAt());
            this.originRule(other.getOriginRule());
            this.context(other.getContext());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="slug", nulls=Nulls.SKIP)
        public Builder slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        public Builder slug(String slug) {
            this.slug = Optional.ofNullable(slug);
            return this;
        }

        @JsonSetter(value="published", nulls=Nulls.SKIP)
        public Builder published(Optional<Boolean> published) {
            this.published = published;
            return this;
        }

        public Builder published(Boolean published) {
            this.published = Optional.ofNullable(published);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="origin_rule", nulls=Nulls.SKIP)
        public Builder originRule(Optional<FlowDetailOriginRule> originRule) {
            this.originRule = originRule;
            return this;
        }

        public Builder originRule(FlowDetailOriginRule originRule) {
            this.originRule = Optional.ofNullable(originRule);
            return this;
        }

        public Builder originRule(Nullable<FlowDetailOriginRule> originRule) {
            this.originRule = originRule.isNull() ? null : (originRule.isEmpty() ? Optional.empty() : Optional.of(originRule.get()));
            return this;
        }

        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public Builder context(Optional<FlowDetailContext> context) {
            this.context = context;
            return this;
        }

        public Builder context(FlowDetailContext context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        public Builder context(Nullable<FlowDetailContext> context) {
            this.context = context.isNull() ? null : (context.isEmpty() ? Optional.empty() : Optional.of(context.get()));
            return this;
        }

        public FlowDetail build() {
            return new FlowDetail(this.id, this.name, this.description, this.slug, this.published, this.updatedAt, this.originRule, this.context, this.additionalProperties);
        }
    }
}

