/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.ImportManifestResponseErrorsItem;
import com.rulebricks.types.ImportManifestResponseImported;
import com.rulebricks.types.ImportManifestResponseSkipped;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ImportManifestResponse {
    private final Optional<String> message;
    private final Optional<ImportManifestResponseImported> imported;
    private final Optional<ImportManifestResponseSkipped> skipped;
    private final Optional<List<ImportManifestResponseErrorsItem>> errors;
    private final Map<String, Object> additionalProperties;

    private ImportManifestResponse(Optional<String> message, Optional<ImportManifestResponseImported> imported, Optional<ImportManifestResponseSkipped> skipped, Optional<List<ImportManifestResponseErrorsItem>> errors, Map<String, Object> additionalProperties) {
        this.message = message;
        this.imported = imported;
        this.skipped = skipped;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message")
    public Optional<String> getMessage() {
        return this.message;
    }

    @JsonProperty(value="imported")
    public Optional<ImportManifestResponseImported> getImported() {
        return this.imported;
    }

    @JsonProperty(value="skipped")
    public Optional<ImportManifestResponseSkipped> getSkipped() {
        return this.skipped;
    }

    @JsonProperty(value="errors")
    public Optional<List<ImportManifestResponseErrorsItem>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImportManifestResponse && this.equalTo((ImportManifestResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ImportManifestResponse other) {
        return this.message.equals(other.message) && this.imported.equals(other.imported) && this.skipped.equals(other.skipped) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.imported, this.skipped, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> message = Optional.empty();
        private Optional<ImportManifestResponseImported> imported = Optional.empty();
        private Optional<ImportManifestResponseSkipped> skipped = Optional.empty();
        private Optional<List<ImportManifestResponseErrorsItem>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ImportManifestResponse other) {
            this.message(other.getMessage());
            this.imported(other.getImported());
            this.skipped(other.getSkipped());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="message", nulls=Nulls.SKIP)
        public Builder message(Optional<String> message) {
            this.message = message;
            return this;
        }

        public Builder message(String message) {
            this.message = Optional.ofNullable(message);
            return this;
        }

        @JsonSetter(value="imported", nulls=Nulls.SKIP)
        public Builder imported(Optional<ImportManifestResponseImported> imported) {
            this.imported = imported;
            return this;
        }

        public Builder imported(ImportManifestResponseImported imported) {
            this.imported = Optional.ofNullable(imported);
            return this;
        }

        @JsonSetter(value="skipped", nulls=Nulls.SKIP)
        public Builder skipped(Optional<ImportManifestResponseSkipped> skipped) {
            this.skipped = skipped;
            return this;
        }

        public Builder skipped(ImportManifestResponseSkipped skipped) {
            this.skipped = Optional.ofNullable(skipped);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<ImportManifestResponseErrorsItem>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<ImportManifestResponseErrorsItem> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public ImportManifestResponse build() {
            return new ImportManifestResponse(this.message, this.imported, this.skipped, this.errors, this.additionalProperties);
        }
    }
}

