/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.CascadeResult;
import com.rulebricks.types.SubmitContextDataResponseStatus;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubmitContextDataResponse {
    private final Optional<String> context;
    private final Optional<Map<String, Object>> state;
    private final Optional<SubmitContextDataResponseStatus> status;
    private final Optional<List<String>> have;
    private final Optional<List<String>> need;
    private final Optional<Boolean> isNew;
    private final Optional<OffsetDateTime> expiresAt;
    private final Optional<List<CascadeResult>> cascaded;
    private final Map<String, Object> additionalProperties;

    private SubmitContextDataResponse(Optional<String> context, Optional<Map<String, Object>> state, Optional<SubmitContextDataResponseStatus> status, Optional<List<String>> have, Optional<List<String>> need, Optional<Boolean> isNew, Optional<OffsetDateTime> expiresAt, Optional<List<CascadeResult>> cascaded, Map<String, Object> additionalProperties) {
        this.context = context;
        this.state = state;
        this.status = status;
        this.have = have;
        this.need = need;
        this.isNew = isNew;
        this.expiresAt = expiresAt;
        this.cascaded = cascaded;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="context")
    public Optional<String> getContext() {
        return this.context;
    }

    @JsonProperty(value="state")
    public Optional<Map<String, Object>> getState() {
        return this.state;
    }

    @JsonProperty(value="status")
    public Optional<SubmitContextDataResponseStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="have")
    public Optional<List<String>> getHave() {
        return this.have;
    }

    @JsonProperty(value="need")
    public Optional<List<String>> getNeed() {
        return this.need;
    }

    @JsonProperty(value="is_new")
    public Optional<Boolean> getIsNew() {
        return this.isNew;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExpiresAt() {
        if (this.expiresAt == null) {
            return Optional.empty();
        }
        return this.expiresAt;
    }

    @JsonProperty(value="cascaded")
    public Optional<List<CascadeResult>> getCascaded() {
        return this.cascaded;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="expires_at")
    private Optional<OffsetDateTime> _getExpiresAt() {
        return this.expiresAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubmitContextDataResponse && this.equalTo((SubmitContextDataResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubmitContextDataResponse other) {
        return this.context.equals(other.context) && this.state.equals(other.state) && this.status.equals(other.status) && this.have.equals(other.have) && this.need.equals(other.need) && this.isNew.equals(other.isNew) && this.expiresAt.equals(other.expiresAt) && this.cascaded.equals(other.cascaded);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.state, this.status, this.have, this.need, this.isNew, this.expiresAt, this.cascaded);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> context = Optional.empty();
        private Optional<Map<String, Object>> state = Optional.empty();
        private Optional<SubmitContextDataResponseStatus> status = Optional.empty();
        private Optional<List<String>> have = Optional.empty();
        private Optional<List<String>> need = Optional.empty();
        private Optional<Boolean> isNew = Optional.empty();
        private Optional<OffsetDateTime> expiresAt = Optional.empty();
        private Optional<List<CascadeResult>> cascaded = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SubmitContextDataResponse other) {
            this.context(other.getContext());
            this.state(other.getState());
            this.status(other.getStatus());
            this.have(other.getHave());
            this.need(other.getNeed());
            this.isNew(other.getIsNew());
            this.expiresAt(other.getExpiresAt());
            this.cascaded(other.getCascaded());
            return this;
        }

        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public Builder context(Optional<String> context) {
            this.context = context;
            return this;
        }

        public Builder context(String context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<Map<String, Object>> state) {
            this.state = state;
            return this;
        }

        public Builder state(Map<String, Object> state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<SubmitContextDataResponseStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(SubmitContextDataResponseStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="have", nulls=Nulls.SKIP)
        public Builder have(Optional<List<String>> have) {
            this.have = have;
            return this;
        }

        public Builder have(List<String> have) {
            this.have = Optional.ofNullable(have);
            return this;
        }

        @JsonSetter(value="need", nulls=Nulls.SKIP)
        public Builder need(Optional<List<String>> need) {
            this.need = need;
            return this;
        }

        public Builder need(List<String> need) {
            this.need = Optional.ofNullable(need);
            return this;
        }

        @JsonSetter(value="is_new", nulls=Nulls.SKIP)
        public Builder isNew(Optional<Boolean> isNew) {
            this.isNew = isNew;
            return this;
        }

        public Builder isNew(Boolean isNew) {
            this.isNew = Optional.ofNullable(isNew);
            return this;
        }

        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public Builder expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        public Builder expiresAt(Nullable<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt.isNull() ? null : (expiresAt.isEmpty() ? Optional.empty() : Optional.of(expiresAt.get()));
            return this;
        }

        @JsonSetter(value="cascaded", nulls=Nulls.SKIP)
        public Builder cascaded(Optional<List<CascadeResult>> cascaded) {
            this.cascaded = cascaded;
            return this;
        }

        public Builder cascaded(List<CascadeResult> cascaded) {
            this.cascaded = Optional.ofNullable(cascaded);
            return this;
        }

        public SubmitContextDataResponse build() {
            return new SubmitContextDataResponse(this.context, this.state, this.status, this.have, this.need, this.isNew, this.expiresAt, this.cascaded, this.additionalProperties);
        }
    }
}

