/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UsageStatistics {
    private final Optional<String> plan;
    private final Optional<String> monthlyPeriodStart;
    private final Optional<String> monthlyPeriodEnd;
    private final Optional<Double> monthlyExecutionsUsage;
    private final Optional<Double> monthlyExecutionsLimit;
    private final Optional<Double> monthlyExecutionsRemaining;
    private final Map<String, Object> additionalProperties;

    private UsageStatistics(Optional<String> plan, Optional<String> monthlyPeriodStart, Optional<String> monthlyPeriodEnd, Optional<Double> monthlyExecutionsUsage, Optional<Double> monthlyExecutionsLimit, Optional<Double> monthlyExecutionsRemaining, Map<String, Object> additionalProperties) {
        this.plan = plan;
        this.monthlyPeriodStart = monthlyPeriodStart;
        this.monthlyPeriodEnd = monthlyPeriodEnd;
        this.monthlyExecutionsUsage = monthlyExecutionsUsage;
        this.monthlyExecutionsLimit = monthlyExecutionsLimit;
        this.monthlyExecutionsRemaining = monthlyExecutionsRemaining;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="plan")
    public Optional<String> getPlan() {
        return this.plan;
    }

    @JsonProperty(value="monthly_period_start")
    public Optional<String> getMonthlyPeriodStart() {
        return this.monthlyPeriodStart;
    }

    @JsonProperty(value="monthly_period_end")
    public Optional<String> getMonthlyPeriodEnd() {
        return this.monthlyPeriodEnd;
    }

    @JsonProperty(value="monthly_executions_usage")
    public Optional<Double> getMonthlyExecutionsUsage() {
        return this.monthlyExecutionsUsage;
    }

    @JsonProperty(value="monthly_executions_limit")
    public Optional<Double> getMonthlyExecutionsLimit() {
        return this.monthlyExecutionsLimit;
    }

    @JsonProperty(value="monthly_executions_remaining")
    public Optional<Double> getMonthlyExecutionsRemaining() {
        return this.monthlyExecutionsRemaining;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UsageStatistics && this.equalTo((UsageStatistics)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UsageStatistics other) {
        return this.plan.equals(other.plan) && this.monthlyPeriodStart.equals(other.monthlyPeriodStart) && this.monthlyPeriodEnd.equals(other.monthlyPeriodEnd) && this.monthlyExecutionsUsage.equals(other.monthlyExecutionsUsage) && this.monthlyExecutionsLimit.equals(other.monthlyExecutionsLimit) && this.monthlyExecutionsRemaining.equals(other.monthlyExecutionsRemaining);
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.monthlyPeriodStart, this.monthlyPeriodEnd, this.monthlyExecutionsUsage, this.monthlyExecutionsLimit, this.monthlyExecutionsRemaining);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> plan = Optional.empty();
        private Optional<String> monthlyPeriodStart = Optional.empty();
        private Optional<String> monthlyPeriodEnd = Optional.empty();
        private Optional<Double> monthlyExecutionsUsage = Optional.empty();
        private Optional<Double> monthlyExecutionsLimit = Optional.empty();
        private Optional<Double> monthlyExecutionsRemaining = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UsageStatistics other) {
            this.plan(other.getPlan());
            this.monthlyPeriodStart(other.getMonthlyPeriodStart());
            this.monthlyPeriodEnd(other.getMonthlyPeriodEnd());
            this.monthlyExecutionsUsage(other.getMonthlyExecutionsUsage());
            this.monthlyExecutionsLimit(other.getMonthlyExecutionsLimit());
            this.monthlyExecutionsRemaining(other.getMonthlyExecutionsRemaining());
            return this;
        }

        @JsonSetter(value="plan", nulls=Nulls.SKIP)
        public Builder plan(Optional<String> plan) {
            this.plan = plan;
            return this;
        }

        public Builder plan(String plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @JsonSetter(value="monthly_period_start", nulls=Nulls.SKIP)
        public Builder monthlyPeriodStart(Optional<String> monthlyPeriodStart) {
            this.monthlyPeriodStart = monthlyPeriodStart;
            return this;
        }

        public Builder monthlyPeriodStart(String monthlyPeriodStart) {
            this.monthlyPeriodStart = Optional.ofNullable(monthlyPeriodStart);
            return this;
        }

        @JsonSetter(value="monthly_period_end", nulls=Nulls.SKIP)
        public Builder monthlyPeriodEnd(Optional<String> monthlyPeriodEnd) {
            this.monthlyPeriodEnd = monthlyPeriodEnd;
            return this;
        }

        public Builder monthlyPeriodEnd(String monthlyPeriodEnd) {
            this.monthlyPeriodEnd = Optional.ofNullable(monthlyPeriodEnd);
            return this;
        }

        @JsonSetter(value="monthly_executions_usage", nulls=Nulls.SKIP)
        public Builder monthlyExecutionsUsage(Optional<Double> monthlyExecutionsUsage) {
            this.monthlyExecutionsUsage = monthlyExecutionsUsage;
            return this;
        }

        public Builder monthlyExecutionsUsage(Double monthlyExecutionsUsage) {
            this.monthlyExecutionsUsage = Optional.ofNullable(monthlyExecutionsUsage);
            return this;
        }

        @JsonSetter(value="monthly_executions_limit", nulls=Nulls.SKIP)
        public Builder monthlyExecutionsLimit(Optional<Double> monthlyExecutionsLimit) {
            this.monthlyExecutionsLimit = monthlyExecutionsLimit;
            return this;
        }

        public Builder monthlyExecutionsLimit(Double monthlyExecutionsLimit) {
            this.monthlyExecutionsLimit = Optional.ofNullable(monthlyExecutionsLimit);
            return this;
        }

        @JsonSetter(value="monthly_executions_remaining", nulls=Nulls.SKIP)
        public Builder monthlyExecutionsRemaining(Optional<Double> monthlyExecutionsRemaining) {
            this.monthlyExecutionsRemaining = monthlyExecutionsRemaining;
            return this;
        }

        public Builder monthlyExecutionsRemaining(Double monthlyExecutionsRemaining) {
            this.monthlyExecutionsRemaining = Optional.ofNullable(monthlyExecutionsRemaining);
            return this;
        }

        public UsageStatistics build() {
            return new UsageStatistics(this.plan, this.monthlyPeriodStart, this.monthlyPeriodEnd, this.monthlyExecutionsUsage, this.monthlyExecutionsLimit, this.monthlyExecutionsRemaining, this.additionalProperties);
        }
    }
}

