/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UserInviteResponseUser {
    private final Optional<String> email;
    private final Optional<String> role;
    private final Optional<List<String>> userGroups;
    private final Map<String, Object> additionalProperties;

    private UserInviteResponseUser(Optional<String> email, Optional<String> role, Optional<List<String>> userGroups, Map<String, Object> additionalProperties) {
        this.email = email;
        this.role = role;
        this.userGroups = userGroups;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonProperty(value="role")
    public Optional<String> getRole() {
        return this.role;
    }

    @JsonProperty(value="user_groups")
    public Optional<List<String>> getUserGroups() {
        return this.userGroups;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UserInviteResponseUser && this.equalTo((UserInviteResponseUser)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UserInviteResponseUser other) {
        return this.email.equals(other.email) && this.role.equals(other.role) && this.userGroups.equals(other.userGroups);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.role, this.userGroups);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> email = Optional.empty();
        private Optional<String> role = Optional.empty();
        private Optional<List<String>> userGroups = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UserInviteResponseUser other) {
            this.email(other.getEmail());
            this.role(other.getRole());
            this.userGroups(other.getUserGroups());
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @JsonSetter(value="role", nulls=Nulls.SKIP)
        public Builder role(Optional<String> role) {
            this.role = role;
            return this;
        }

        public Builder role(String role) {
            this.role = Optional.ofNullable(role);
            return this;
        }

        @JsonSetter(value="user_groups", nulls=Nulls.SKIP)
        public Builder userGroups(Optional<List<String>> userGroups) {
            this.userGroups = userGroups;
            return this;
        }

        public Builder userGroups(List<String> userGroups) {
            this.userGroups = Optional.ofNullable(userGroups);
            return this;
        }

        public UserInviteResponseUser build() {
            return new UserInviteResponseUser(this.email, this.role, this.userGroups, this.additionalProperties);
        }
    }
}

