/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.javax.script;

import com.scriptbasic.Version;
import com.scriptbasic.factories.SingletonFactoryFactory;
import com.scriptbasic.interfaces.Configuration;
import com.scriptbasic.javax.script.ScriptEngine;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.utility.FactoryUtility;
import com.scriptbasic.utility.ReflectionUtility;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;

public class ScriptEngineFactory
implements javax.script.ScriptEngineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptEngineFactory.class);
    private Bindings globalScopeBinding;
    private String engineName = "ScriptBasic";
    private String version = Version.version;
    private List<String> extensions = Version.extensions;
    private List<String> mimeTypes = Version.mimeTypes;
    private List<String> names = Version.names;
    private String language = "scriptbasic";
    private String languageVersion = "4.0j";
    private Configuration config = FactoryUtility.getConfiguration(SingletonFactoryFactory.getFactory());

    public Bindings getGlobalScopeBinding() {
        return this.globalScopeBinding;
    }

    public void setGlobalScopeBinding(Bindings globalScopeBinding) {
        this.globalScopeBinding = globalScopeBinding;
    }

    private void loadKeys(String key) {
        String keys = key + "s";
        if (this.config != null && this.config.getConfigValue(key + "." + 0) != null) {
            try {
                ArrayList<String> list = new ArrayList<String>();
                ReflectionUtility.setField(this, keys, list);
                int i = 0;
                while (this.config.getConfigValue(key + "." + i) != null) {
                    if (this.config.getConfigValue(key + "." + i).length() > 0) {
                        list.add(this.config.getConfigValue(key));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                LOG.error("Can not intialize the configuration parameters from configuration", e);
            }
        }
    }

    public ScriptEngineFactory() {
        if (this.config.getConfigValue("engineName") != null) {
            this.engineName = this.config.getConfigValue("engineName");
        }
        if (this.config.getConfigValue("version") != null) {
            this.version = this.config.getConfigValue("version");
        }
        if (this.config.getConfigValue("language") != null) {
            this.language = this.config.getConfigValue("language");
        }
        if (this.config.getConfigValue("languageVersion") != null) {
            this.languageVersion = this.config.getConfigValue("languageVersion");
        }
        this.loadKeys("extension");
        this.loadKeys("mimeType");
        this.loadKeys("name");
    }

    @Override
    public String getEngineName() {
        return this.engineName;
    }

    @Override
    public String getEngineVersion() {
        return this.version;
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getLanguageName() {
        return this.language;
    }

    @Override
    public String getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public Object getParameter(String key) {
        switch (key) {
            case "javax.script.engine": {
                return this.getEngineName();
            }
            case "javax.script.engine_version": {
                return this.getEngineVersion();
            }
            case "javax.script.name": {
                return this.getNames();
            }
            case "javax.script.language": {
                return this.getLanguageName();
            }
            case "javax.script.language_version": {
                return this.getLanguageVersion();
            }
            case "THREADING": {
                return "STATELESS";
            }
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        String sep = "";
        String argsS = "";
        for (String arg : args) {
            argsS = sep + arg;
            sep = ",";
        }
        return String.format("%s.%s(%s)", obj, m, argsS);
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return String.format("print \"%s\"", toDisplay);
    }

    @Override
    public String getProgram(String ... statements) {
        int len = 0;
        for (String line : statements) {
            len += 1 + line.length();
        }
        StringBuilder sb = new StringBuilder(len);
        for (String line : statements) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    @Override
    public javax.script.ScriptEngine getScriptEngine() {
        return new ScriptEngine(this);
    }
}

